% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_functions.R
\name{estimateInterimTheta}
\alias{estimateInterimTheta}
\title{(Internal) Estimate interim theta}
\usage{
estimateInterimTheta(
  o,
  j,
  position,
  augmented_current_theta,
  augmented_item_pool,
  model_code,
  augmented_item_index,
  augmented_item_resp,
  include_items_for_estimation,
  item_parameter_sample,
  config,
  simulation_constants,
  bayesian_constants
)
}
\arguments{
\item{o}{an \code{\linkS4class{output_Shadow}} object.}

\item{j}{the numeric index of the examinee.}

\item{position}{the item position, ranging from 1 to test length.}

\item{augmented_current_theta}{current theta estimate, based on any extra items supplied to the simulation.}

\item{augmented_item_pool}{the \code{\linkS4class{item_pool}} object, also including any extra items supplied to the simulation.}

\item{model_code}{machine-sanitized item model codes for passing onto C++ functions.}

\item{augmented_item_index}{item indices of items administered to this examinee, also including any extra items supplied to the simulation.}

\item{augmented_item_resp}{responses for items administered to this examinee, also including any extra items supplied to the simulation.}

\item{include_items_for_estimation}{an examinee-wise list containing:
\itemize{
  \item{\code{administered_item_pool}} items to include in theta estimation as \code{\linkS4class{item_pool}} object.
  \item{\code{administered_item_resp}} item responses to include in theta estimation.
}}

\item{item_parameter_sample}{a list containing numerical samples of item parameters that reflect item parameter estimation uncertainty.
The output of \code{\link{iparPosteriorSample}} goes here.}

\item{config}{a \code{\linkS4class{config_Shadow}} object. Use \code{\link{createShadowTestConfig}} for this.}

\item{simulation_constants}{a named list containing simulation constants.}

\item{bayesian_constants}{a named list containing Bayesian constants.}
}
\value{
\code{\link{estimateInterimTheta}} returns an updated \code{\linkS4class{output_Shadow}} object.
}
\description{
\code{\link{estimateInterimTheta}} is an internal function for
estimating interim theta.
}
\keyword{internal}
