% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_data_gen.R
\name{tensor_data_gen}
\alias{tensor_data_gen}
\title{Tensor time series data generation.}
\usage{
tensor_data_gen(K, n, d, r, re, eta, u, heavy_tailed = FALSE, t_df = 3)
}
\arguments{
\item{K}{The number of modes for the tensor time series.}

\item{n}{Length of time series.}

\item{d}{Dimensions of each mode of the tensor, written in a vector of length \code{K}.}

\item{r}{Rank of the core tensors, written in a vector of length \code{K}.}

\item{re}{Rank of the cross-sectional common error core tensors, written in a vector of length \code{K}.}

\item{eta}{Quantities controlling factor strengths in each factor loading matrix, written in a list of \code{K} vectors.}

\item{u}{Quantities controlling range of elements in each factor loading matrix, written in a list of \code{K} vectors.}

\item{heavy_tailed}{Whether to generate data from heavy-tailed distribution. If FALSE, generate from N(0,1); if TRUE, generate from t-distribution. Default is FALSE.}

\item{t_df}{The degree of freedom for t-distribution if heavy_tailed = TRUE. Default is 3.}
}
\value{
A list containing the following: \cr
\code{X}: the generated tensor time series, stored in a 'Tensor' object defined in \pkg{rTensor}, where mode-1 is the time mode \cr
\code{A}: a list of K factor loading matrices \cr
\code{F_ts}: time series of core tensor, stored in a 'Tensor' object, where mode-1 is the time mode \cr
\code{E_ts}: time series of error tensor, stored in a 'Tensor' object, where mode-1 is the time mode \cr
}
\description{
Function to generate a random sample of time series tensor factor model, based on econometrics assumptions. (See Chen and Lam (2023) for more details on the assumptions.)
}
\details{
Input tensor dimension and rank of core tensor, return a sample of tensor time series generated by factor model.
}
\examples{
\donttest{
set.seed(10)
K = 2
n = 100
d = c(40,40)
r = c(2,2)
re = c(2,2)
eta = list(c(0,0),c(0,0))
u = list(c(-2,2),c(-2,2))
Data_test = tensor_data_gen(K,n,d,r,re,eta,u)

X = Data_test$X
A = Data_test$A
F_ts = Data_test$F_ts
E_ts = Data_test$E_ts

X@modes
F_ts@modes
E_ts@modes
dim(A[[1]])
}
}
