% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.TendrilPerm.R
\name{plot.TendrilPerm}
\alias{plot.TendrilPerm}
\title{Plot TendrilPerm}
\usage{
\method{plot}{TendrilPerm}(x, coloring = "p.adj", percentile = FALSE,
  ...)
}
\arguments{
\item{x}{An object of class TendrilPerm, as made by TendrilPerm()}

\item{coloring}{Name of column used for coloring tendrils.
Available coloring choices are:
  "Terms" - One tendril one color;
  "p" - Prop.test;
  "p.adj" - P-values adjusted using the False discovery rate method within each tendril;
  "fish" - Fisher.test;
  "rdiff" - Risk difference;
  "RR" - Risk Ratio;
  "OR" - Odds Ratio;
  "FDR.tot" - P-values adjusted using the False discovery rate method for all tendrils; and
  "TermsCount" - Total number of events for that specific type of event}

\item{percentile}{Specifies if the plot must show percentile values.
Default is FALSE.}

\item{...}{unused}
}
\description{
Function to plot TendrilPerm results
}
\examples{
# generate data using Tendril()
data <- Tendril(mydata = TendrilData,
rotations = Rotations,
AEfreqThreshold = 9,
Tag = "Comment",
Treatments = c("placebo", "active"),
Unique.Subject.Identifier = "subjid",
Terms = "ae",
Treat = "treatment",
StartDay = "day",
SubjList = SubjList,
SubjList.subject = "subjid",
SubjList.treatment = "treatment"
)
tendril_perm <- TendrilPerm(
  tendril = data,
  PermTerm="AE40",
  n.perm = 200,
  perm.from.day = 1)

#Do plot
res <- plot(tendril_perm)
res <- plot(tendril_perm, percentile = TRUE)

#To re-do the plot after the first call:
print(res)
}
