% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpermutation.R
\name{getpermutation}
\alias{getpermutation}
\title{Get permutation}
\usage{
getpermutation(n, pos)
}
\arguments{
\item{n}{Number of players, as an integer.}

\item{pos}{Position according to the Lehmer code, as an integer.}
}
\value{
The permutation of \code{n} players whose Lehmer code position is \code{pos}, as a vector.
}
\description{
Given a number of players and a position, this function returns the permutation of players that occupies the given position when permutations are arranged according to the Lehmer code.
}
\details{
The Lehmer code makes use of the fact that there are \eqn{n!} permutations of a sequence of \eqn{n} numbers.
If a permutation \eqn{\sigma} is specified by the sequence \eqn{(\sigma_{i})_{i=1}^{n}}, its Lehmer code is the
sequence \eqn{L(\sigma)=(L(\sigma)_{i})_{i=1}^{n}}, where \eqn{L(\sigma)_i=|\{j>i:\sigma_j<\sigma_i\}|}.

The position of permutation \eqn{\sigma} according to the Lehmer code order is
\deqn{L_{\sigma}=1 + \sum_{i=1}^{n} (n-i)! L(\sigma)_i}.
}
\examples{
getpermutation(4, 5)
n <- 4
for (i in 1:factorial(n)) {
  cat("[", i, "]", paste(getpermutation(n,i)), "\n")
}
}
\seealso{
\link{getpermutationnumber}
}
