% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2lex.R
\name{bin2lex}
\alias{bin2lex}
\title{Binary order to lexicographic order}
\usage{
bin2lex(v)
}
\arguments{
\item{v}{A characteristic function, as a vector in binary order.}
}
\value{
The characteristic function, as a vector in lexicographic order.
}
\description{
Given a characteristic function in binary order, this function returns the characteristic function in lexicographic order.
}
\details{
The binary order position of a coalition \eqn{S\in 2^N} is given by \eqn{\sum_{i\in S} 2^{i-1}}. Lexicographic order arranges coalitions in ascending order according to size, and applies lexicographic order to break ties among coalitions of the same size.
}
\examples{
v <- seq(1:31)
bin2lex(v)
lex2bin(bin2lex(v))==v
}
\seealso{
\link{codebin2lex}, \link{codelex2bin}, \link{lex2bin}
}
