% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ttr.R
\name{predict_ttr}
\alias{predict_ttr}
\title{Make a prediction from a fitted model}
\usage{
predict_ttr(parms, Model, Data, new.input = NULL, options = NULL, optim = NULL)
}
\arguments{
\item{parms}{A vector of parameters compatible with the data object 'Data' and the user defined Model function}

\item{Model}{A user defined Model function that accepts 'parms' and 'Data' as input}

\item{Data}{A Data object as produced by \code{make_data()}}

\item{new.input}{If the prediction should use different forcing data from 'Data', this can be an input object as returned by \code{get_input()}}

\item{options}{If the prediction should use different options from 'Data', this can be supplied as an options list as required by \code{make_data()}}

\item{optim}{If the user defined Model function tests for 'optim' in options, this can be used to set it. Defaults to the string "no"}
}
\value{
The prediction as specified in the user defined Model function
}
\description{
Make a prediction from a fitted TTR.PGM model.
}
\details{
\code{predict_ttr()} returns the data object specified when the option 
'Data$options$optim' in the user defined Model is set to "no". 
See the vignette for an example.
}
