% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_config_chart.R
\name{config_chart_multi_solutions}
\alias{config_chart_multi_solutions}
\title{Generate configuration chart for multiple solutions (simple interface)}
\usage{
config_chart_multi_solutions(
  solutions,
  symbol_set = c("unicode", "ascii", "latex"),
  language = c("en", "ja"),
  condition_order = NULL,
  show_epi = FALSE
)
}
\arguments{
\item{solutions}{List of character vectors. Each element is a vector of 
paths for one solution.}

\item{symbol_set}{Character. One of \code{"unicode"}, \code{"ascii"}, 
or \code{"latex"}.}

\item{language}{Character. \code{"en"} for English, \code{"ja"} for Japanese.}

\item{condition_order}{Character vector. Optional ordering of conditions.}

\item{show_epi}{Logical. Whether to identify and display Essential Prime
Implicants (EPIs) in the note. Default is FALSE.}
}
\value{
Character string containing Markdown-formatted tables.
}
\description{
Generates separate configuration charts for multiple solutions.
}
\examples{
# Multiple solutions
solutions <- list(
  c("A*B", "C"),
  c("A*B", "D"),
  c("A*C")
)
chart <- config_chart_multi_solutions(solutions)
cat(chart)

# With EPI identification
chart <- config_chart_multi_solutions(solutions, show_epi = TRUE)
cat(chart)
}
