% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateEnrichement.R
\name{calculateEnrichmentTest}
\alias{calculateEnrichmentTest}
\title{performs enrichment analysis}
\usage{
calculateEnrichmentTest(
  DEGs,
  catalog,
  TFs,
  TF.col = "TF..OFFICIAL_TF_CODING_GENE_NAME."
)
}
\arguments{
\item{DEGs}{a character vector of DEGs (differentially expressed genes)}

\item{catalog}{a data frame of TFactS catalog (ver. 2)}

\item{TFs}{a character vector of transcription factor}

\item{TF.col}{the name of the column that contains the TF names}
}
\value{
data.frame
}
\description{
This function performs enrichment test (ET) based on Fisher's exact test
}
\examples{
data(DEGs)
data(catalog)

tftg <- extractTFTG(DEGs, catalog)
TFs <- tftg$TFs

res <- calculateEnrichmentTest(DEGs, catalog, TFs)

}
\references{
Essaghir A et al. Nucleic Acids Res. 2010 Jun;38(11):e120.
}
\author{
Atsushi Fukushima
Definition:
m is the number of target genes annotated for the TF
under consideration
n is the number of query genes
N is the number of regulations in the catalog
k is the number of query genes that are annotated as
regulated by TF (i.e., the intersection between the
query and the TF signature)
}
