% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_lookup.R
\name{add_dash_one}
\alias{add_dash_one}
\title{Add \code{-01} to gene names lacking gene-level info}
\usage{
add_dash_one(gene_str)
}
\arguments{
\item{gene_str}{A string, the gene name.}
}
\value{
A string, the updated gene name.
}
\description{
Some genes just have the IMGT subgroup (e.g. TRBV2) and allele (e.g. *01)
designation. The Adaptive format always includes an IMGT gene (e.g. -01)
designation, with "-01" as the apparent default. \code{add_dash_one()} adds a
default gene-level designation if it's missing.
}
\examples{
add_dash_one("TRBV2*01")
}
\keyword{internal}
