% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tad.R
\name{launch_analysis_tad}
\alias{launch_analysis_tad}
\title{Launch the analysis}
\usage{
launch_analysis_tad(
  weights,
  weights_factor,
  trait_data,
  randomization_number,
  aggregation_factor_name = NULL,
  statistics_factor_name = NULL,
  seed = NULL,
  abundance_file = NULL,
  weighted_moments_file = NULL,
  stat_per_obs_file = NULL,
  stat_per_rand_file = NULL,
  stat_skr_param_file = NULL,
  regenerate_abundance_df = FALSE,
  regenerate_weighted_moments_df = FALSE,
  regenerate_stat_per_obs_df = FALSE,
  regenerate_stat_per_rand_df = FALSE,
  regenerate_stat_skr_df = FALSE,
  significativity_threshold = CONSTANTS$DEFAULT_SIGNIFICATIVITY_THRESHOLD,
  lin_mod = CONSTANTS$DEFAULT_LIN_MOD,
  slope_distance = CONSTANTS$DEFAULT_SLOPE_DISTANCE,
  intercept_distance = CONSTANTS$DEFAULT_INTERCEPT_DISTANCE,
  csv_tsv_load_parameters = list()
)
}
\arguments{
\item{weights}{the dataframe of weights, one row correspond to a
series of observation}

\item{weights_factor}{the dataframe which contains the different
factor linked to the weights}

\item{trait_data}{a vector of the data linked to the different factor}

\item{randomization_number}{the number of random abundance matrix to
generate}

\item{aggregation_factor_name}{vector of factor name for the
generation of random matrix}

\item{statistics_factor_name}{vector of factor name for the
computation of statistics for each generated matrix}

\item{seed}{the seed of the pseudo random number generator}

\item{abundance_file}{the path and name of the RDS file to
load/save the dataframe which
contains the observed data and the generated matrix}

\item{weighted_moments_file}{the path and name of the RDS file to
load/save the dataframe which
contains the calculated moments}

\item{stat_per_obs_file}{the path and name of the RDS file to
load/save the dataframe which
contains the statistics for each observed row regarding the random ones}

\item{stat_per_rand_file}{the path and name of the RDS file to
load/save the dataframe which
contains the statistics for each random matrix generated}

\item{stat_skr_param_file}{default=NULL You can provide the output to write
the SKR statistics results to.}

\item{regenerate_abundance_df}{boolean to specify if the
abundance dataframe is computed again}

\item{regenerate_weighted_moments_df}{boolean to specify if
the weighted moments dataframe is computed again}

\item{regenerate_stat_per_obs_df}{boolean to specify if
the statistics per observation dataframe is computed again}

\item{regenerate_stat_per_rand_df}{boolean to specify if
the statistics per random matrix dataframe is computed again}

\item{regenerate_stat_skr_df}{boolean to specify if
the stats SKR dataframe is computed again}

\item{significativity_threshold}{the significance threshold to
consider that the observed value is in the randomized value}

\item{lin_mod}{Indicates the type of linear model to use for
(SKR): choose "lm" or "mblm"}

\item{slope_distance}{slope of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform distribution family)}

\item{intercept_distance}{intercept of the theoretical distribution
law (default: slope = 1 intercept = 1.86 skew-uniform distribution family)}

\item{csv_tsv_load_parameters}{a list of parameters for each data structure
we want to load. Each element must be named after the data structure
we want to load.}
}
\value{
A \code{list} of the 9 following named elements:
\itemize{
\item raw_abundance_df
\item filtered_weights
\item filtered_weights_factor
\item filtered_trait_data
\item abundance_df
\item weighted_moments
\item statistics_per_observation
\item stat_per_rand
\item ses_skr
}
}
\description{
Launch distribution analysis
}
\examples{

  output_path <- file.path(tempdir(), "outputs")
  dir.create(output_path)
  results <- TAD::launch_analysis_tad(
    weights = TAD::AB[, 5:102],
    weights_factor = TAD::AB[, c("Year", "Plot", "Treatment", "Bloc")],
    trait_data = log(TAD::trait[["SLA"]]),
    aggregation_factor_name = c("Year", "Bloc"),
    statistics_factor_name = (statistics_factor_name <- c("Treatment")),
    regenerate_abundance_df = TRUE,
    regenerate_weighted_moments_df = TRUE,
    regenerate_stat_per_obs_df = TRUE,
    regenerate_stat_per_rand_df = TRUE,
    weighted_moments_file = file.path(output_path, "weighted_moments.csv"),
    stat_per_obs_file = file.path(output_path, "stat_per_obs.csv"),
    stat_per_rand_file = file.path(output_path, "stat_per_rand.csv"),
    stat_skr_param_file = file.path(output_path, "stat_skr_param.csv"),
    randomization_number = 20,
    seed = 1312,
    significativity_threshold = c(0.05, 0.95),
    lin_mod = "lm",
    slope_distance = (
      slope_distance <- TAD::CONSTANTS$SKEW_UNIFORM_SLOPE_DISTANCE
    ),
    intercept_distance = (
      intercept_distance <- TAD::CONSTANTS$SKEW_UNIFORM_INTERCEPT_DISTANCE
    )
  )
  moments_graph <- TAD::moments_graph(
    moments_df = results$weighted_moments,
    statistics_per_observation = results$statistics_per_observation,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    output_path = file.path(output_path, "moments_graph.jpeg"),
    dpi = 100
  )
  skr_graph <- TAD::skr_graph(
    moments_df = results$weighted_moments,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    output_path = file.path(output_path, "skr_graph.jpeg"),
    slope_distance = slope_distance,
    intercept_distance = intercept_distance,
    dpi = 100
  )
  skr_param_graph <- TAD::skr_param_graph(
    skr_param = results$ses_skr,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    slope_distance = slope_distance,
    intercept_distance = intercept_distance,
    save_skr_param_graph = file.path(output_path, "skr_param_graph.jpeg"),
    dpi = 100
  )

  unlink(output_path, recursive = TRUE, force = TRUE)

}
\concept{tad}
