% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess-function.R
\name{preprocess_SCD}
\alias{preprocess_SCD}
\title{Clean Single Case Design Data}
\usage{
preprocess_SCD(
  design,
  case,
  phase,
  session,
  outcome,
  cluster = NULL,
  series = NULL,
  center = 0,
  round_session = TRUE,
  treatment_name = NULL,
  data = NULL
)
}
\arguments{
\item{design}{Character string to specify whether data comes from a treatment
reversal (\code{"TR"}), multiple baseline across participants
(\code{"MBP"}), replicated multiple baseline across behaviors
(\code{"RMBB"}), or clustered multiple baseline across participants
(\code{"CMB"}).}

\item{case}{vector of case indicators or name of a character or factor vector
within \code{data} indicating unique cases.}

\item{phase}{vector of treatment indicators or name of a character or factor
vector within \code{data} indicating unique treatment phases.}

\item{session}{vector of measurement occasions or name of numeric vector
within \code{data} of measurement times.}

\item{outcome}{vector of outcome data or name of numeric vector of outcome
data within \code{data}.}

\item{cluster}{(Optional) vector of cluster indicators or name of a character
or factor vector within \code{data} indicating clusters.}

\item{series}{(Optional) vector of series indicators or name of a character
or factor vector within \code{data} indicating series.}

\item{center}{Numeric value for the centering value for session. Default is 0.}

\item{round_session}{Logical indicating whether to round \code{session} to the nearest integer. Defaults to \code{TRUE}.}

\item{treatment_name}{(Optional) character string corresponding to the name
of the treatment phase.}

\item{data}{(Optional) dataset to use for analysis. Must be a
\code{data.frame}.}
}
\value{
A cleaned SCD dataset that can be used for model fitting and effect size calculation.
}
\description{
Clean single case design data for treatment reversal and multiple baseline designs.
}
\note{
If treatment_name is left null it will choose the second level of the phase variable to be the treatment phase.
}
\examples{
data(Laski)
preprocess_SCD(design = "MBP", 
               case = case, phase = treatment,
               session = time, outcome = outcome, 
               center = 4, data = Laski)
               
data(Anglesea) 
preprocess_SCD(design="TR",
               case=case, phase=condition,
               session=session, outcome=outcome,
               treatment_name = "treatment",
               data=Anglesea)
               
data(Thiemann2001)
preprocess_SCD(design = "RMBB", 
               case = case, series = series, phase = treatment, 
               session = time, outcome = outcome, 
               data = Thiemann2001)
          
}
