% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_plumber_file.R
\name{apply_plumber2_block}
\alias{apply_plumber2_block}
\title{Generic for applying information from a plumber2 block to an api}
\usage{
apply_plumber2_block(block, api, route_name, root, ...)
}
\arguments{
\item{block}{The block that was parsed}

\item{api}{The \link{Plumber2} api object to apply it to}

\item{route_name}{The name of the route the plumber2 file is associated with.
Either the name of the file or the value of the \verb{@routeName} tag}

\item{root}{The root given by the potential \verb{@root} tag in the file. If no
\verb{@root} tag is present this value will be null. The value represents the root
path for every endpoint defined in the file and should be prepended to any
URL path you use.}

\item{...}{ignored}
}
\value{
\code{api}, modified
}
\description{
In order to facilitate extensibility of the plumber2 file syntax you can
provide your own methods for how to apply information from a plumber2 block
to an api.
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Add a method for a fictional "hello_block" that makes the api say hello when
# it starts
apply_plumber2_block.hello_block <- function(block, api, route_name, root, ...) {
  api$on("start", function(...) {
    message("Hello")
  })
  api
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=add_plumber2_tag]{add_plumber2_tag()}}
}
\keyword{internal}
