% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-get-grid-parameters.R
\name{DoU_get_grid_parameters}
\alias{DoU_get_grid_parameters}
\title{Get the parameters for the DEGURBA grid cell classification}
\usage{
DoU_get_grid_parameters(level1 = TRUE)
}
\arguments{
\item{level1}{logical. Whether to return the standard parameters of level 1 of the Degree of Urbanisation (\code{TRUE}), or level 2 of the Degree of Urbanisation (\code{FALSE}).}
}
\value{
named list with the standard parameters
}
\description{
The argument \code{parameter} of the function \code{\link[=DoU_classify_grid]{DoU_classify_grid()}} allows to adapt the standard specifications in the Degree of Urbanisation in order to construct an alternative version of the grid classification. This function returns a named list with the standard parameters.
}
\examples{
# example on how to employ the function to construct
# an alternative version of the grid classification:
# get the standard parameters
parameters <- DoU_get_grid_parameters()

# adapt the standard parameters
parameters$UCL_density_threshold <- 500
parameters$UCL_size_threshold <- 6000
parameters$UCL_smooth_pop <- TRUE
parameters$UCL_smooth_pop_window <- 7

# load the data
grid_data <- DoU_load_grid_data_belgium()

# use the adapted parameters to construct a grid cell classification
classification <- DoU_classify_grid(
  data = grid_data,
  parameters = parameters
)
}
