% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_stat.R
\name{sum_stat}
\alias{sum_stat}
\title{Descriptive Summary Table for Continuous and Categorical Variables}
\arguments{
\item{data}{A data frame containing the variables to summarize.}

\item{by}{Optional. A grouping variable (column name as string) to stratify the summary table.}

\item{statistic}{Character. Summary statistic for continuous variables. Either \code{"mean_sd"} (default) or \code{"med_iqr"}.}
}
\value{
A \code{flextable} object displaying the summary table with appropriate formatting for publication or reporting.
Continuous variables show mean (SD) or median (IQR), and categorical variables show counts and percentages.
If \code{by} is specified, summaries are presented for each group in separate columns.
}
\description{
This function generates descriptive summary tables for both continuous and categorical variables.
Continuous variables can be summarized using mean (SD) or median (IQR), and categorical variables
are summarized as counts and percentages. Optionally, summaries can be stratified by a grouping variable.
}
\examples{
sum_stat(iris)
sum_stat(iris, by = "Species", statistic = "mean_sd")
sum_stat(iris, statistic = "med_iqr")
}
