% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching_diagnostics.R
\name{balance_diagnostics}
\alias{balance_diagnostics}
\title{Balance Diagnostics for Matched Pairs}
\usage{
balance_diagnostics(
  result,
  left,
  right,
  vars = NULL,
  left_id = "id",
  right_id = "id"
)
}
\arguments{
\item{result}{A matching result object from \code{match_couples()} or
\code{greedy_couples()}}

\item{left}{Data frame of left units}

\item{right}{Data frame of right units}

\item{vars}{Character vector of variable names to check balance for.
Defaults to the variables used in matching (if available in result).}

\item{left_id}{Character, name of ID column in left data (default: "id")}

\item{right_id}{Character, name of ID column in right data (default: "id")}
}
\value{
An S3 object of class \code{balance_diagnostics} containing:
\describe{
\item{var_stats}{Tibble with per-variable balance statistics}
\item{overall}{List with overall balance metrics}
\item{pairs}{Tibble of matched pairs with variables}
\item{n_matched}{Number of matched pairs}
\item{n_unmatched_left}{Number of unmatched left units}
\item{n_unmatched_right}{Number of unmatched right units}
\item{method}{Matching method used}
\item{has_blocks}{Whether blocking was used}
\item{block_stats}{Per-block statistics (if blocking used)}
}
}
\description{
Computes comprehensive balance statistics comparing the distribution of
matching variables between left and right units in the matched sample.
}
\details{
This function computes several balance metrics:

Standardized Difference: The difference in means divided by the pooled
standard deviation. Values less than 0.1 indicate excellent balance,
0.1-0.25 good balance.

Variance Ratio: The ratio of standard deviations (left/right).
Values close to 1 are ideal.

KS Statistic: Kolmogorov-Smirnov test statistic comparing distributions.
Lower values indicate more similar distributions.

Overall Metrics include mean absolute standardized difference across
all variables, proportion of variables with large imbalance
(|std diff| > 0.25), and maximum standardized difference.
}
\examples{
# Create sample data
set.seed(123)
left <- data.frame(
  id = 1:10,
  age = rnorm(10, 45, 10),
  income = rnorm(10, 50000, 15000)
)
right <- data.frame(
  id = 11:30,
  age = rnorm(20, 47, 10),
  income = rnorm(20, 52000, 15000)
)

# Match
result <- match_couples(left, right, vars = c("age", "income"))

# Get balance diagnostics
balance <- balance_diagnostics(result, left, right, vars = c("age", "income"))
print(balance)

# Get balance table
balance_table(balance)

}
