% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_start_task}
\alias{ecs_start_task}
\title{Start Task}
\usage{
ecs_start_task(
  cluster = NULL,
  containerInstances = NULL,
  enableECSManagedTags = NULL,
  group = NULL,
  networkConfiguration = NULL,
  overrides = NULL,
  propagateTags = NULL,
  referenceId = NULL,
  startedBy = NULL,
  tags = NULL,
  taskDefinition = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster on which to start your task.}

\item{containerInstances}{List. The container instance IDs or full ARN entries for the container instances on which you would like...}

\item{enableECSManagedTags}{Logical. Specifies whether to enable Amazon ECS managed tags for the task.}

\item{group}{Character. The name of the task group to associate with the task.}

\item{networkConfiguration}{Object. The VPC subnet and security group configuration for tasks that receive their own elastic network...}

\item{overrides}{Object.   A list of container overrides in JSON format that specify the name of a container in the specified...}

\item{propagateTags}{Character. Specifies whether to propagate the tags from the task definition or the service to the task.}

\item{referenceId}{Character. The reference ID to use for the task.}

\item{startedBy}{Character.   An optional tag specified when a task is started.}

\item{tags}{List.   The metadata that you apply to the task to help you categorize and organize them.}

\item{taskDefinition}{Character. The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task definition to start.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Start Task
}
\section{cluster}{

The
short name or full Amazon Resource Name (ARN) of the cluster on which to
start your task. If you do not specify a cluster, the default cluster is
assumed.
}

\section{containerInstances}{

The container instance IDs or full ARN
entries for the container instances on which you would like to place
your task. You can specify up to 10 container
instances.
}

\section{enableECSManagedTags}{

Specifies whether to enable Amazon ECS
managed tags for the task. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging Your Amazon ECS Resources}
in the \emph{Amazon Elastic Container Service Developer
Guide}.
}

\section{group}{

The name of the task group to associate with
the task. The default value is the family name of the task definition
(for example, family:my-family-name).
}

\section{networkConfiguration}{

The VPC subnet
and security group configuration for tasks that receive their own
elastic network interface by using the \code{awsvpc} networking
mode.
}

\section{overrides}{


A list of container overrides in JSON format that specify the name of a
container in the specified task definition and the overrides it should
receive. You can override the default command for a container (that is
specified in the task definition or Docker image) with a \code{command}
override. You can also override existing environment variables (that are
specified in the task definition or Docker image) on a container or add
new environment variables to it with an \code{environment} override.

A total of 8192 characters are allowed for overrides. This limit
includes the JSON formatting characters of the override structure.
}

\section{propagateTags}{

Specifies whether to propagate the tags from the
task definition or the service to the task. If no value is specified,
the tags are not propagated.
}

\section{referenceId}{

The reference ID to use
for the task.
}

\section{startedBy}{


An optional tag specified when a task is started. For example, if you
automatically trigger a task to run a batch process job, you could apply
a unique identifier for that job to your task with the \code{startedBy}
parameter. You can then identify which tasks belong to that job by
filtering the results of a ListTasks call with the \code{startedBy} value. Up
to 36 letters (uppercase and lowercase), numbers, hyphens, and
underscores are allowed.

If a task is started by an Amazon ECS service, then the \code{startedBy}
parameter contains the deployment ID of the service that starts it.
}

\section{tags}{


The metadata that you apply to the task to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}
}

\section{taskDefinition}{

The \code{family} and \code{revision} (\code{family:revision}) or
full ARN of the task definition to start. If a \code{revision} is not
specified, the latest \code{ACTIVE} revision is used.
}

