% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxDT.R
\name{coxDT}
\alias{coxDT}
\title{Fit Cox Proportional Hazards Regression Model Under Independent Double Truncation}
\usage{
coxDT(
  formula,
  L,
  R,
  data,
  subset,
  time.var = FALSE,
  subject = NULL,
  B.SE.np = 200,
  CI.boot = FALSE,
  B.CI.boot = 2000,
  pvalue.boot = FALSE,
  B.pvalue.boot = 500,
  B.pvalue.se.boot = 100,
  trunc.weight = 100,
  print.weights = FALSE,
  error = 10^-6,
  n.iter = 1000
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right. The response must be a survival object as returned by the \code{Surv} function. NOTE: \code{coxDT} does not handle censoring.}

\item{L}{vector of left truncation times}

\item{R}{vector right truncation times}

\item{data}{mandatory data.frame matrix needed to interpret variables named in the \code{formula}}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process. All observations are included by default.}

\item{time.var}{default = FALSE. If TRUE, specifies that time varying covariates are included in the model.}

\item{subject}{a vector of subject identification numbers. Only needed if time.var=TRUE (see example).}

\item{B.SE.np}{number of iterations for bootstrapped standard error (default = 200)}

\item{CI.boot}{requests bootstrap confidence intervals (default==FALSE)}

\item{B.CI.boot}{number of iterations for bootstrapped confidence intervals (default = 2000)}

\item{pvalue.boot}{requests bootstrap p-values (default==FALSE)}

\item{B.pvalue.boot}{number of iterations for numerator (estimate) of bootstrapped test statistic (default = 500)}

\item{B.pvalue.se.boot}{number of iterations for denominator (standard error) of bootstrapped test statistic (default = 100)}

\item{trunc.weight}{Truncates weights at a prespecified level (default=100). Trade off is a slight increase in bias for reduction in variance.}

\item{print.weights}{requests the output of nonparametric selection probabilities (default==FALSE)}

\item{error}{convergence criterion for nonparametric selection probabilities (default = 10e-6)}

\item{n.iter}{maximum number of iterations for computation of nonparamteric selection probabilities (default = 1000)}
}
\value{
\item{results.beta}{Displays the estimate, standard error, lower and upper 95\% Wald confidence limits,
Wald test statistic and corresponding p-value for each regression coefficient}
\item{CI}{Method used for computation of confidence interval: Normal approximation (default) or bootstrap}
\item{p.value}{Method used for computation of p-values: Normal approximation (default) or bootstrap}
\item{weights}{If print.weights=TRUE, displays the weights used in the Cox model}
}
\description{
Fits a Cox proportional hazards regression model when the survival time is subject to both left and right truncation. Assumes that the truncation times are independent of survival times, and no censoring is present in the data.
}
\details{
Fits a Cox proportional hazards model in the presence of left and right truncation
by weighting each subject in the score equation of the Cox model by the probability that they
are observed in the sample. These selection probabilities are computed nonparametrically.
The estimation procedure here is performed using coxph {survival} and inserting these estimated
selection probabilities in the 'weights' option. This method assumes that the survival and
truncation times are independent. Furthermore, this method does not accommodate censoring.
Note: If only left truncation is present, set R=infinity.
If only right truncation is present, set L = -infinity.
}
\examples{
###### Example: AIDS data set #####
coxDT(Surv(Induction.time)~Adult,L.time,R.time,data=AIDS,B.SE.np=2)

# WARNING: To save computation time, number of bootstrap resamples for standard error set to 2.
# Note: The minimum recommendation is 200, which is the default setting.
##### Including time-dependent covariates #####
# Accomodating time-dependent covariates in the model is similar to the accomodation in coxph

# The data set may look like the following:

# subject start stop event treatment test.score L.time R.time
# 1       T.10  T.11  1    X.1       Z.1        L.1    R.1
# 2       T.20  T.21  0    X.2       Z.21       L.2    R.2
# 2       T.21  T.22  1    X.2       Z.22       L.2    R.2
#...

# Here the variable 'treatment' and the trunction times 'L.time' and 'R.time' stay the same
# from line to line. The variable 'test.score' will vary line to line. In this example,
# subject 1 has only one recorded measurement for test.score, and therefore only has one row
# of observations. Subject 2 has two recorded measurements for test score, and therefore has
# two rows of observations. In this example, it is assumed that the test score for subject 2
# is fixed at Z.21 between (T.20,T.21] and fixed at Z.22 between (T.21,T.22]. Notice that
# the event indicator is 0 in the first row of observations corresponding to subject 2,
# since they have not yet experienced the event. The status variable changes to 1 in the
# row where the event occurs.

# Note: Start time cannot preceed left truncation time and must be strictly less than stop time.

# example


test.data <- data.frame(
list(subject.id = c(1, 2, 2, 3, 4, 4, 5, 6, 7, 8, 8, 9, 10),
    start      = c(3, 5, 7, 2, 1, 2, 6, 5, 6, 6, 7, 2, 17),
    stop       = c(4, 7, 8, 5, 2, 6, 9, 8, 7, 7, 9, 6, 21),
    event      = c(1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1),
    treatment  = c(0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1),
    test.score = c(5, 6, 7, 4, 6, 9, 3, 4, 4, 7, 6, 4, 12),
    L.time     = c(2, 4, 4, 2, 1, 1, 4, 5, 4, 3, 3, 1, 10),
    R.time     = c(6, 9, 9, 6, 7, 7, 9, 9, 8, 8, 9, 8, 24)))

 coxDT(Surv(start,stop,event)~treatment+test.score,L.time,R.time,data=test.data,
 time.var=TRUE,subject=subject.id,B.SE.np=2)
}
\references{
Rennert L and Xie SX (2018). Cox regression model with doubly truncated data. Biometrics, 74(2), 725-733. http://dx.doi.org/10.1111/biom.12809.
}
