% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HealthData_Logistic_Boot.R
\name{mspe_LOGISTIC_HealthData_BOOT}
\alias{mspe_LOGISTIC_HealthData_BOOT}
\title{MSPE estimation in mixed logistic model (Health Insurance data) using bootstrap method. Calculate the mspe of mixed logistic model (Health Insurance data) using bootstrap method.}
\usage{
mspe_LOGISTIC_HealthData_BOOT(
  m,
  p,
  n.new,
  y.new,
  cum.n.new,
  Xi,
  yi.tem,
  X.tem,
  county.tem,
  B
)
}
\arguments{
\item{m}{number of domains}

\item{p}{number of complete model parameters}

\item{n.new}{sample size of each domain}

\item{y.new}{response variable}

\item{cum.n.new}{Cummulaticve sum of n}

\item{Xi}{covariates}

\item{yi.tem}{response variable for each individual}

\item{X.tem}{Individual level covariates}

\item{county.tem}{county}

\item{B}{number of bootstrap iterations}
}
\value{
Par: return estimation of model parameters

Mu.hat: return prediction of domain parameters

mspe.boot: return mspe of small area (domain) predictor using the bootstrap method

sq.mspe.boot: return square root of mspe of small area predictor for non-zero domains using the bootstrap method
}
\description{
MSPE estimation in mixed logistic model (Health Insurance data) using bootstrap method. Calculate the mspe of mixed logistic model (Health Insurance data) using bootstrap method.
}
\examples{
mspe_LOGISTIC_HealthData_BOOT(20,3,c(2,1,2,2,1,2,3,1,1,3,1,3,2,3,3,
1,2,1,3,3),c(3,4,2,2,3,3,4,3,4,1,4,1,3,5,4,7,1,3,1,2),c(2,3,5,7,8,10,13,14,15
,18,19,22,24,27,30,31,33,34,37,40),
matrix(runif(60,0,1),nrow=20,byrow=TRUE),sample(c(0,1),replace=TRUE,40),
matrix(c(runif(40,7,10),runif(40,14,22),runif(40,2,4)),nrow=40,byrow=FALSE),
rep(1:20,each=2),10)


}
