% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FH_PR.R
\name{mspe_FH_PR}
\alias{mspe_FH_PR}
\title{MSPE estimation in FH model using Prasad-Rao method. Calculate the mspe of Fay-Herriot model in SAE using Prasad-Rao method.}
\usage{
mspe_FH_PR(m, p, X, beta, A, D, R)
}
\arguments{
\item{m}{number of small areas}

\item{p}{number of fixed model parameters}

\item{X}{Covariates}

\item{beta}{regression coefficients}

\item{A}{variance of area-specific random effects}

\item{D}{sampling variance}

\item{R}{number of simulation runs}
}
\value{
Par: return estimation of model parameters

MSPE.TRUE.Final: return empirical MSPE of small area predictor

mspe.PR.Final: return mspe of small area predictor using the Prasad-Rao method

RB.PR: return relative bias (RB) of mspe of small area predictor using the Prasad-Rao method
}
\description{
MSPE estimation in FH model using Prasad-Rao method. Calculate the mspe of Fay-Herriot model in SAE using Prasad-Rao method.
}
\examples{
mspe_FH_PR(20,3,matrix(runif(60,0,1),nrow=20,byrow=TRUE),c(1,1,1),10,2.5,10)


}
