% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimTrial.R
\name{SimTrial}
\alias{SimTrial}
\title{Simulates a Sub-TITE trial design}
\usage{
SimTrial(
  nSims,
  Nmax,
  T1,
  Target,
  Dose,
  DoseStart,
  Upper,
  Accrue,
  groupprob,
  meanmu,
  meanslope,
  MeanInts,
  MeanSlopes,
  VarInt,
  VarSlope,
  phetero,
  Family,
  SimTruth,
  NSep,
  NBorrow,
  cohort,
  FULL
)
}
\arguments{
\item{nSims}{Number of Trials to Simulate.}

\item{Nmax}{Maximum Number of Patients to enroll in the trial.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability (or subgroup specific vector) at time T1.}

\item{Dose}{Standardized vector of doses to try.}

\item{DoseStart}{Dose (or vector of Doses) to enroll the first patient in each subgroup at.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{Accrue}{Expected montly patient accrual rate.}

\item{groupprob}{Probability vector of subgroup assignment.}

\item{meanmu}{Prior mean of the baseline intercept parameter.}

\item{meanslope}{Prior mean of the baseline slope parameter.}

\item{MeanInts}{G-1 length vector of subgroup specific prior intercept means.}

\item{MeanSlopes}{G-1 length vector of subgroup specific prior slope means.}

\item{VarInt}{Prior Variance of Intercept Parameters.}

\item{VarSlope}{Prior Variance of Slope Parameters.}

\item{phetero}{Prior probability of clustering}

\item{Family}{What distribution Family to simulate from. Options include: Exponential,Gamma, Lognormal, Uniform, Weibull.}

\item{SimTruth}{List of 2 #Groups by #Doses matrices containing the true parameter values needed for simulating from different true time to toxicity distributions. When a Uniform distribution is chosen, the user will instead supply the true toxicity probabilities for each dose/subgroup combination in both list entries. For a gamma distribution, the user will supply a matrix for the shape parameters for each dose and subgroup, and a second matrix for the rate parameters of each dose and subgroup.}

\item{NSep}{Number of patients to assign based on no borrowing.}

\item{NBorrow}{Number of patients to assign based on no clustering}

\item{cohort}{Number of patients to enroll before escalating.}

\item{FULL}{Do we have to fully evaluate a cohort before escalating?}
}
\value{
A list with first entry corresponding to summaries of the operating characteristics of the design including
}
\description{
Simulates replicates from a Sub-TITE trial with user specified true toxicity time distributions for different doses and subgroups and returns average summary statistics of the trial.
}
\examples{
##Note: nSims  should be set larger than the example below.
nSims=1
###TRIAL PARAMETERS###
##Specify reference toxicity time and target
T1=6
Target=.3
##Number of Groups
##Specify upper bound for determining if the lowest dose is too toxic in a subgroup
Upper=c(.95,.95)
#' ##Standardized Dose Values and starting dose index
Dose=sort(rnorm(5))
DoseStart=1
##Maximum Sample Size
Nmax=25
##Number of patients to run separately
NSep=0
##Number of patients to borrow, but NOT cluster
NBorrow=0
##Number of patients to fully evaluate or TREAT before ESCALATING
cohort=3
##Do we fully evaluate a cohort before escalating?
FULL=0
#HYPERPARAMETERS#
##Hypermeans for baseline terms
meanmu=2.21
meanslope=-.57
##Hypervectors for subgroup specific terms
MeanInts = c(0,.46)
MeanSlopes = c(0,.04)
##Hypervariances
VarInt=5
VarSlope=1
######SIMULATION TRUTH####
##True Accrual Rate
Accrue=2
##True Distribution of subgroups
groupprob=c(.5,.5)
##True Group Toxicity probabilities at each dose level
GroupProb =matrix(c(.05,.3,.6,.7,.8,.01,.02,.13,.27,.5),nrow=2,byrow=TRUE)
##True Simulation distribution
Family="Uniform"
SimTruth = as.list(c(0,0))
SimTruth[[1]]=GroupProb
SimTruth[[2]]=GroupProb
phetero=.9
RESULTS=SimTrial(nSims,Nmax,T1,Target,Dose,DoseStart,
              Upper,Accrue,groupprob,meanmu,meanslope,
              MeanInts,MeanSlopes,VarInt,VarSlope,phetero,
              Family,SimTruth,NSep,NBorrow,cohort,FULL)
              RESULTS[[1]]
}
