% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetParams.R
\name{GetParams}
\alias{GetParams}
\title{Obtains true simulation parameters for each supported distribution function to correspond to a probability of the truth by time T1.}
\usage{
GetParams(Family, ParamNum, Param, GroupProb, T1)
}
\arguments{
\item{Family}{What distribution Family to simulate from. Options include: Exponential,Gamma, Lognormal, Uniform, Weibull.}

\item{ParamNum}{Parameter index for user set value. For example, ParamNum=1 for a Gamma distribution means that the user will supply the shape parameters in the param matrix. If ParamNum=2, the user will supply the rate parameters in the param matrix.}

\item{Param}{#Groups X #Doses Matrix containing one parameter for each subgroup and dose.}

\item{GroupProb}{#Groups X #Doses Matrix containing the true toxicity probability by time T1.}

\item{T1}{Toxicity observation window.}
}
\value{
A list containing the hyperparameter matrices to input into the SimTrial function. Also plots the hazard of toxicity for each subgroup and dose.
}
\description{
Obtains true simulation parameters for each supported distribution function to correspond to a probability of the truth by time T1.
}
\examples{
GroupProb =matrix(c(.05,.3,.6,.7,.8,.01,.02,.13,.27,.5),nrow=2,byrow=TRUE)
##True Simulation distribution
Family="Weibull"
T1=6
Param = GroupProb*0 + 4 ##Late onset weibull
SimTruth = GetParams("Weibull",1,Param,GroupProb,T1)
}
