% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otmatch.R
\name{otmatch}
\alias{otmatch}
\title{Statistical Matching using Optimal transport}
\usage{
otmatch(
  X1,
  id1,
  X2,
  id2,
  w1,
  w2,
  dist_method = "Euclidean",
  transport_method = "shortsimplex",
  EPS = 1e-09
)
}
\arguments{
\item{X1}{A matrix, the matching variables of sample 1.}

\item{id1}{A character or numeric vector that contains the labels of the units in sample 1.}

\item{X2}{A matrix, the matching variables of sample 2.}

\item{id2}{A character or numeric vector that contains the labels of the units in sample 1.}

\item{w1}{A numeric vector that contains the weights of the sample 1, harmonized by the function \code{\link{harmonize}}.}

\item{w2}{A numeric vector that contains the weights of the sample 2, harmonized by the function \code{\link{harmonize}}.}

\item{dist_method}{A string that specified the  distance used by the function \code{\link[proxy:dist]{dist}} of the package \code{proxy}. Default \code{"Euclidean"}.}

\item{transport_method}{A string that specified the  distance used by the function \code{\link[transport:transport]{transport}} of the package \code{transport}. Default \code{"shortsimplex"}.}

\item{EPS}{an numeric scalar to determine if the value is rounded to 0.}
}
\value{
A data.frame that contains the matching. The first two columns contain the unit identities of the two samples. The third column is the final weights. All remaining columns are the matching variables.
}
\description{
This function computes the statistical matching between two complex survey samples with weighting schemes. The function uses the function \code{\link[transport:transport]{transport}} of the package \code{transport}.
}
\details{
All details of the method can be seen in : Raphaël Jauslin and Yves Tillé (2021) <arXiv:2105.08379>.
}
\examples{

#--- SET UP
N=1000
p=5
X=array(rnorm(N*p),c(N,p))
EPS= 1e-9

n1=100
n2=200

s1 = sampling::srswor(n1,N)
s2 = sampling::srswor(n2,N)


id1=(1:N)[s1==1]
id2=(1:N)[s2==1]

d1=rep(N/n1,n1)
d2=rep(N/n2,n2)

X1=X[s1==1,]
X2=X[s2==1,]

#--- HARMONIZATION

re=harmonize(X1,d1,id1,X2,d2,id2)
w1=re$w1
w2=re$w2

#--- STATISTICAL MATCHING WITH OT

object = otmatch(X1,id1,X2,id2,w1,w2)


round(colSums(object$weight*object[,4:ncol(object)]),3)
round(colSums(w1*X1),3)
round(colSums(w2*X2),3)
}
