% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_class-Strategy.R
\docType{class}
\name{Strategy-class}
\alias{Strategy-class}
\title{\code{Strategy}-Class}
\description{
An S4 class to store quantitative strategies and compute various performance figures.
}
\section{Slots}{

\describe{
\item{\code{prices}}{Price data of the assets. If return data was given within the constructor, starting at 100.}

\item{\code{weights}}{Time series of class \code{xts} indicating row wise weights of the assets.}

\item{\code{indicators}}{List of indicators of class \code{xts}.}

\item{\code{strat}}{Name of the strategy function to be called. Could be a full file path to a custom strategy.}

\item{\code{strat.params}}{List of parameters as input for the strategy function. List entry names should match parameter names.}

\item{\code{stratFUN}}{Contains the custom strategy function or \code{NULL}.}

\item{\code{plotFUN}}{Contains the custom strategy function or \code{NULL}.}

\item{\code{filters}}{List with filtered price data (e.g. MA(200)-data).}

\item{\code{signals}}{Time series with trading signals of class \code{xts}.}

\item{\code{backtest.signals}}{Time series with trading signals of the backtest of class \code{xts}.}

\item{\code{backtest.parameters}}{List of parameters of the backtest.}

\item{\code{backtest.setup}}{Matrix showing the backtest preferences.}

\item{\code{volume}}{Numeric vector indicating the initial investment volume per asset.}

\item{\code{costs.fix}}{Numeric vector indicating the fixed costs per trade per asset.}

\item{\code{costs.rel}}{Numeric vector indicating the relative costs per trade per asset.}
}}

