% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnorm1_precision_sampler.R
\name{rnorm1_precision_sampler}
\alias{rnorm1_precision_sampler}
\title{Samples random draws from a multivariate normal distribution using the 
precision sampler by Chan & Jeliazkov (2009)}
\usage{
rnorm1_precision_sampler(location, precision_diag, precision_offdiag)
}
\arguments{
\item{location}{an \eqn{N}-vector with the location parameter \eqn{L}. 
\strong{C++}: an \code{arma:vec} vector object.}

\item{precision_diag}{an \eqn{N}-vector with the diagonal elements of the 
precision matrix \eqn{P}. \strong{C++}: an \code{arma:vec} vector object.}

\item{precision_offdiag}{a numeric scalar with the off-diagonal element of 
the precision matrix \eqn{P}. \strong{C++}: a \code{double} scalar.}
}
\value{
an \eqn{N}-vector with random draws from the multivariate normal 
distribution. \strong{C++}: an \code{arma:vec} vector object.
}
\description{
Samples random numbers from an \eqn{N}-variate normal distribution
specified by the \eqn{N\times N} precision matrix \eqn{P} and \eqn{N\times 1}
location vector \eqn{L} as per:
\deqn{N(P^{-1}L, P^{-1})}
where the precision matrix \eqn{P} is bi-diagonal with the diagonal elements 
given in the vector argument \code{precision_diag} and the off-diagonal element 
is given in the scalar argument \code{precision_offdiag}, and the location 
vector \eqn{L} is provided in the vector argument \code{location}. 

This method is useful for the simulation smoother of the linear Gaussian 
state-space models with the state variable specified by the autoregressive
dynamics with one lag, AR(1). See Woźniak (2021) for more details.
}
\details{
This function is based on C++ code from the R package \pkg{stochvol}
by Hosszejni & Kastner (2025) and Kastner G. (2016) and is using 
objects and commands from the \pkg{armadillo} library by Sanderson & Curtin (2025)
thanks to the \pkg{RcppArmadillo} package by Eddelbuettel, Francois, Bates, 
Ni, & Sanderson (2025)
}
\examples{
rnorm1_precision_sampler(rep(0, 100), rep(1, 100), -0.5)

}
\references{
Chan J.C.C., Jeliazkov I. (2009). Efficient simulation and integrated 
likelihood estimation in state space models. International Journal of 
Mathematical Modelling and Numerical Optimisation, 
1(1/2), <doi:10.1504/IJMMNO.2009.030090>.

Eddelbuettel D., Francois R., Bates D., Ni B., Sanderson C. (2025). 
RcppArmadillo: 'Rcpp' Integration for the 'Armadillo' Templated Linear 
Algebra Library. R package version 15.0.2-2. <doi:10.32614/CRAN.package.RcppArmadillo>

Hosszejni D., Kastner G. (2025). stochvol: Efficient Bayesian Inference for 
Stochastic Volatility (SV) Models. R package version 3.2.8, 
<doi:10.32614/CRAN.package.stochvol>

Kastner G. (2016). Dealing with Stochastic Volatility in Time Series Using 
the R Package stochvol. Journal of Statistical Software, 69(5), 1–30. 
<doi:10.18637/jss.v069.i05>.

Sanderson C., Curtin R. (2025). Armadillo: An Efficient Framework for 
Numerical Linear Algebra. International Conference on Computer and Automation 
Engineering, 303-307, <doi:10.1109/ICCAE64891.2025.10980539>

Woźniak T. (2021). Simulation Smoother using RcppArmadillo, 
RcppGallery \url{https://gallery.rcpp.org/articles/simulation-smoother-using-rcpparmadillo/}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
