% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_treated.R
\name{assign_treated}
\alias{assign_treated}
\title{Let the package know which observations were treated}
\usage{
assign_treated(data, polygon, id = NA)
}
\arguments{
\item{data}{sf data frame containing point data (if you have polygons, convert first with sf::st_centroid())}

\item{polygon}{sf object with polygon geometry that fully describes the area(s) that contain the treated points}

\item{id}{string that represents the name of the column in the data that represents the unique identifier for each observation}
}
\value{
A vector of type factor with 0's and 1's. Convert with as.numeric() if you want real numbers/integers.
}
\description{
Creates a vector with 0's and 1's to determine on which side of the cut-off each observation is. For this it is useful to have a polygon that fully describes the "treated area".
If you do not have such a polygon there is a (preliminary and patchy) way implemented in the package via \code{\link{points2line}} and \code{\link{cutoff2polygon}} that lets you go from points to line to "treated polygon" in a very crude way.
}
\note{
This is essentially a wrapper of \code{sf::st_intersection}.
}
\examples{
points_samp.sf <- sf::st_sample(polygon_full, 100) # create points
# make it an sf object bc st_sample only created the geometry list-column (sfc):
points_samp.sf <- sf::st_sf(points_samp.sf)
# add a unique ID to each observation:
points_samp.sf$id <- 1:nrow(points_samp.sf)
points_samp.sf$treated <- assign_treated(points_samp.sf, polygon_treated, id = "id")

}
