% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretise_border.R
\name{discretise_border}
\alias{discretise_border}
\title{Split the RD cut-off into borderpoints}
\usage{
discretise_border(
  cutoff,
  n = 10,
  random = FALSE,
  range = FALSE,
  ymax = NA,
  ymin = NA,
  xmax = NA,
  xmin = NA
)
}
\arguments{
\item{cutoff}{sf object of the RD cut-off in the form of a line (not preferred, but also boundarypoints are possible)}

\item{n}{the number of borderpoints to be created}

\item{random}{whether they are randomly chosen (not desireable in most cases)}

\item{range}{default = FALSE, if there is a specific range (N-S or E-W) for which the points are to be drawn (useful in order to exclude sparse borderpoints with little/no oberservations around because the non-parametric RD estimation will fail)}

\item{ymax}{if range = TRUE: y coordinates}

\item{ymin}{if range = TRUE: y coordinates}

\item{xmax}{if range = TRUE: x coordinates}

\item{xmin}{if range = TRUE: x coordinates}
}
\value{
an sf object with selected (and evenly spaced) borderpoints
}
\description{
Takes in a border in the form of a polyline (or borderpoints) and converts it into point data.
These points are later used to run separate non-parametric RD estimations which eventually allows to visualise potential heterogeneous treatment effects alongside the cut-off.
}
\examples{
borderpoints <- discretise_border(cutoff = cut_off, n = 10)

}
