% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_placebos.R
\name{create_placebos}
\alias{create_placebos}
\title{Multiple placebocheks unified in just one list or coefplot}
\usage{
create_placebos(
  data,
  cutoff,
  formula,
  operations,
  bw_dist,
  coefplot = FALSE,
  geometry = FALSE
)
}
\arguments{
\item{data}{sf data.frame that contains all units of observation}

\item{cutoff}{initial RD cutoff as an sj object}

\item{formula}{provide the formula you want to use for OLS, omit the treatetment dummy (if you want a univariate regression just on "treated", then provide y ~ 1 as formula)}

\item{operations}{container that has all the information in it on how to change the border for each placeboregression}

\item{bw_dist}{what is the distance for the bandwith (in CRS units, thus ideally metres)}

\item{coefplot}{provide coefplot instead of a data.frame}

\item{geometry}{set to \code{TRUE} if you want to plot all the lines of the used placebo borders}
}
\value{
either a coefplot or data.frame containing results of placebo regressions
}
\description{
Unifies \code{\link{shift_border}}, \code{\link{cutoff2polygon}}, \code{\link{assign_treated}} in one function to carry out a myriad of placebo checks at once.
The output is either a data.frame (with or without geometry of the respective placeboline) or a coefplot.
Requires operations data.frame that contains all desired operations (columns shift.x, shift.y, scale, angle, orientation.1, orientation.2, endpoint.1, endpoint.2),
if you don't need a certain operation just use default values (e.g. 0 for angle and 1 for scale), but the column has to be there.
}
\examples{
points_samp.sf <- sf::st_sample(polygon_full, 100) # create points
# make it an sf object bc st_sample only created the geometry list-column (sfc):
points_samp.sf <- sf::st_sf(points_samp.sf)
# add a unique ID to each observation:
points_samp.sf$id <- 1:nrow(points_samp.sf)
points_samp.sf$treated <- assign_treated(points_samp.sf, polygon_treated, id = "id")
operations.df <- data.frame(operation = c("shift"),
                            shift.x = c(0),
                            shift.y = c(0),
                            scale = 1,
                            angle = 0,
                            orientation.1 = c("west"),
                            orientation.2 = c("west"),
                            endpoint.1 = c(.8),
                            endpoint.2 = c(.2))
create_placebos(data = points_samp.sf, cutoff = cut_off,
formula = id ~ 1, operations = operations.df, bw_dist = 3000)
}
