% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spader.R
\name{ChaoShared}
\alias{ChaoShared}
\title{Estimation of the number of shared species between two communities/assemblages}
\usage{
ChaoShared(data, datatype = c("abundance", "incidence_freq", "incidence_raw"),
  units, se = TRUE, nboot = 200, conf = 0.95)
}
\arguments{
\item{data}{a matrix/data.frame of species abundances/incidences.\cr}

\item{datatype}{type of input data, "abundance", "incidence_freq" or "incidence_raw". \cr}

\item{units}{number of sampling units in each community. For \code{datatype = "incidence_raw"}, users must specify the number of sampling units taken from each community. This argument is not needed for "abundance" and "incidence_freq" data.\cr}

\item{se}{a logical variable to calculate the bootstrap standard error and the associated confidence interval. \cr}

\item{nboot}{an integer specifying the number of bootstrap replications. \cr}

\item{conf}{a positive number \eqn{\le} 1 specifying the level of confidence interval.}
}
\value{
a list of two objects: \cr\cr
\code{$Basic_data_information} for summarizing data information. \cr\cr
\code{$Estimation_results} for showing a table of various shared richess estimates, standard errors, and the associated confidence intervals. \cr\cr
}
\description{
\code{ChaoShared}: Estimation of shared species richness between two communities/assemblages based on
three types of data: Type (1) abundance data (datatype="abundance"), Type (2) incidence-frequency
data (datatype="incidence_freq"), and Type (2B) incidence-raw data (datatype="incidence\cr 
_raw"); see \code{SpadeR-package} details for data input formats.
}
\examples{
data(ChaoSharedData)
# Type (1) abundance data
ChaoShared(ChaoSharedData$Abu,"abundance",se=TRUE,nboot=200,conf=0.95)
# Type (2) incidence-frequency data 
ChaoShared(ChaoSharedData$Inci,"incidence_freq",se=TRUE,nboot=200,conf=0.95)
# Type (2B) incidence-raw data   
ChaoShared(ChaoSharedData$Inci_raw,"incidence_raw",units=c(16,17),se=TRUE,nboot=200,conf=0.95)
}
\references{
Chao, A., Hwang, W.-H., Chen, Y.-C. and Kuo. C.-Y. (2000). Estimating the  number of shared species in two communities. Statistica Sinica, 10, 227-246.\cr\cr
Pan, H.-Y., Chao, A. and Foissner, W. (2009). A non-parametric lower bound for the number of species shared by multiple communities. Journal of Agricultural, Biological and Environmental Statistics, 14, 452-468.
}

