% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile.R
\name{percentile}
\alias{percentile}
\title{percentile}
\usage{
percentile(
  LF = NULL,
  probs = c(0.025, 0.975),
  na.rm = TRUE,
  sort_probs = TRUE,
  unique_probs = TRUE
)
}
\arguments{
\item{LF}{Numeric vector of length-frequency data (e.g., \code{data$length}).}

\item{probs}{Numeric vector of probabilities in \eqn{[0,1]} indicating which
percentiles to calculate. Default is \code{c(0.025, 0.975)} as per SlotLim.}

\item{na.rm}{Logical; if \code{TRUE} (default), \code{NA}s are removed before computing
percentiles. If \code{FALSE}, \code{NA} values may propagate to the result.}

\item{sort_probs}{Logical; if \code{TRUE} (default), \code{probs} are sorted ascending
(labels follow the returned order). If \code{FALSE}, percentiles are returned in
the input order.}

\item{unique_probs}{Logical; if \code{TRUE} (default), duplicate \code{probs} are
deduplicated (first occurrence kept for labeling).}
}
\value{
A named list (length = length of \code{probs}) where each element
corresponds to the requested percentile. Names are formatted as \code{L_x},
where \code{x} is the percentile value in percent (e.g., \code{L_2.5}, \code{L_97.5}).
}
\description{
Calculates specified percentiles from length-frequency data.
}
\details{
Uses \code{stats::quantile(..., type = 7)}, the R default. Labels drop trailing
zeros (e.g., \code{L_5} not \code{L_5.0}).
}
\examples{
length_data <- c(10, 9, 7, 10, 11, 13, NA, 11, 6, 20)
percentile(length_data)  # default 2.5th and 97.5th
percentile(length_data, probs = c(0.05, 0.95)) # 5th and 95th percentiles

}
