% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_pharm_mod.R
\name{fit_pharm_mod}
\alias{fit_pharm_mod}
\title{Fitting a pharmacokinetic model to concentration data}
\usage{
fit_pharm_mod(time, conc, m, plot = TRUE)
}
\arguments{
\item{time}{a vector containing the time points of measurements}

\item{conc}{data frame or matrix containing the concentrations (see the example)}

\item{m}{model type. Built-in models are "firstorder",  "hixson",  "higuchi", "weibull" and "logistic"}

\item{plot}{plot of the model, default is TRUE.}
}
\value{
A list containing the model type and the obtained parameters, further the RSS for all possible models. Furthermore a plot is given.
}
\description{
This function fits a pharmacokinetic model (dissolution profile) to time-concentration data using non-linear least squares regression.
The model can be chosen from a candidate set containing a First order, Hixson-Crowell,Higuchi, Weibull and a logistic model.
See Moellenhoff et al. (2018) <doi:10.1002/sim.7689> for details.
}
\examples{
data(example_data)
conc1 <- select(filter(example_data,Group=="1"),-Tablet,-Group)
time <- c(10,15,20,30,45,60)
fit_pharm_mod(time,conc1,m="logistic")
}
\references{
Moellenhoff et al. (2018) <doi:10.1002/sim.7689>
}
