% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_CI_function.R
\name{get_CI}
\alias{get_CI}
\title{get_CI}
\usage{
get_CI(
  alpha,
  lower_bds,
  upper_bds,
  parameter_index,
  seeds,
  generating_fun,
  s_obs,
  tol,
  theta_init = NULL,
  T_stat = ma_depth,
  verbose = FALSE,
  check_input = TRUE
)
}
\arguments{
\item{alpha}{A numeric representing the significance level of the test.}

\item{lower_bds}{A vector containing the lower bounds for the parameter search space.}

\item{upper_bds}{A vector containing the upper bounds for the parameter search space.}

\item{parameter_index}{An integer indicating the parameter of interest.}

\item{seeds}{A matrix (or array) of seeds for generating artificial statistics.}

\item{generating_fun}{A function that takes the random seeds above and a parameter in the search space as inputs to generate artificial statistics.}

\item{s_obs}{A vector representing the observed statistic.}

\item{tol}{A numeric specifying the tolerance of the confidence interval.}

\item{theta_init}{A vector specifying the starting point for the initial \code{optim} search.}

\item{T_stat}{Default to the Mahalanobis distance. See Vignette for detailed explanation.}

\item{verbose}{A Boolean variable indicating whether or not to print out the \code{optim} messages.}

\item{check_input}{A Boolean variable indicating whether or not to run checks on the function inputs.}
}
\value{
A length-2 vector representing the obtained confidence interval. In the case when no point is accepted in the search space, return \code{NULL}.
}
\description{
Given the observed statistic, this function computes a confidence interval given that the data generating process is known using the supplied random seeds.
}
\examples{
### Note that the examples may take a few seconds to run.
### Regular Normal
set.seed(123)
n <- 30 # sample size
R <- 50 # Repro sample size (should be at least 200 for accuracy in practice)
alpha <- .05 # significance level
tol <- 0.01 # tolerance for the confidence set (use smaller tolerance in practice)
s_obs <- c(1.12, 0.67) # the observed sample mean and variance
seeds <- matrix(rnorm(R * (n + 2)), nrow = R, ncol = n + 2) # pre-generated seeds

# this function computes the repro statistics given the seeds and the parameter
s_sample <- function(seeds, theta) {
# generate the raw data points
  raw_data <- theta[1] + sqrt(theta[2]) * seeds[, 1:n]

  # compute the regular statistics
  s_mean <- apply(raw_data, 1, mean)
  s_var <- apply(raw_data, 1, var)

  return(cbind(s_mean, s_var))
}

lower_bds <- c(-5, 0.01) # lower bounds for the parameter search region
upper_bds <- c(5, 5) # upper bounds for the parameter search region

# choose parameter_index = 1 to get the confidence interval for the mean
mean_CI <- get_CI(alpha, lower_bds, upper_bds, 1, seeds, s_sample, s_obs, tol)
print(mean_CI) # estimated confidence interval for mean
var_CI <- get_CI(alpha, lower_bds, upper_bds, 2, seeds, s_sample, s_obs, tol)
print(var_CI) # estimated confidence interval for variance

}
