% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumdy.r
\name{cumdy}
\alias{cumdy}
\title{Function to detect year transitions and calculate cumulative age
of model results}
\usage{
cumdy(resultarray, threshold = 5, plotyearmarkers = TRUE)
}
\arguments{
\item{resultarray}{Array containing the full results of
the optimized growth model}

\item{threshold}{Artificial threshold value used to recognize
peaks in occurrences of year transitions (default = 5)}

\item{plotyearmarkers}{Should the location of identified year
transitions be plotted? \code{TRUE/FALSE}}
}
\value{
A new version of the resultarray with Julian Day model
estimates replaced by estimates of cumulative age of the record
in days.
}
\description{
Takes the result of iterative growth modeling and
transforms data from Julian Day (0 - 365) to cumulative
day of the shell age by detecting where transitions
from one year to the next occur and adding full years
(365 days) to simulations in later years.
}
\examples{
testarray <- array(NA, dim = c(20, 16, 9)) # Create empty array
# with correct third dimension
windowfill <- seq(50, 500, 50) # Create dummy simulation data 
# (ages) to copy through the array
for(i in 6:length(testarray[1, , 1])){
    testarray[, i, 3] <- c(windowfill, rep(NA, length(testarray[, 1, 3]) -
        length(windowfill)))
    windowfill <- c(NA, (windowfill + 51) \%\% 365)
}
testarray[, 1, 3] <- seq(1, length(testarray[, 1, 3]), 1) # Add
# dummy /code{D} column.
testarray2 <- cumdy(testarray, 3, FALSE) # Apply function on array
}
\references{
package dependencies: zoo 1.8.7
}
