% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setSeaSondeRCS_FOR_MAXP}
\alias{seasonder_setSeaSondeRCS_FOR_MAXP}
\title{Set Maximum Power (MAXP) for First Order Region (FOR)}
\usage{
seasonder_setSeaSondeRCS_FOR_MAXP(seasonder_cs_object, FOR_MAXP)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object to which the \code{MAXP} values will be assigned.}

\item{FOR_MAXP}{A list containing the maximum power values for each range cell.}
}
\value{
The updated \code{SeaSondeRCS} object with the \code{MAXP} values stored in the \code{FOR_data} attribute.
}
\description{
This function assigns the computed maximum power values (\code{MAXP}) for each range cell
in the First Order Region (FOR) to the \code{SeaSondeRCS} object.
}
\details{
The maximum power (\code{MAXP}) represents the highest spectral power detected in the first-order region.
This value is extracted from the self-spectra and used for setting first-order boundaries.

\strong{Validation Considerations:}
\itemize{
\item The function does not currently perform explicit validation on \code{FOR_MAXP}.
\item Future improvements should ensure that \code{FOR_MAXP} contains numeric values corresponding to each range cell.
}
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNulls}} for computing \code{MAXP}.
\item \code{\link{seasonder_setSeaSondeRCS_FOR_MAXP.bin}} for setting maximum power bin indices.
}
}
