% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_currmax}
\alias{seasonder_setFOR_currmax}
\title{Set FOR Maximum Velocity (currmax)}
\usage{
seasonder_setFOR_currmax(seasonder_cs_object, currmax)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object with FOR parameters.}

\item{currmax}{A numeric value specifying the new maximum radial velocity.}
}
\value{
The updated SeaSondeRCS object with the new \code{currmax} value.
}
\description{
This function sets the maximum radial velocity (\code{currmax}) allowed in the first-order region
for the SeaSondeRCS object.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFOR_currmax(cs_obj, 2.5)
}
