% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFORParameter}
\alias{seasonder_setFORParameter}
\title{Set a Specific FOR Parameter for a SeaSondeRCS Object}
\usage{
seasonder_setFORParameter(seasonder_cs_object, FOR_parameter, value)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing FOR-related metadata.}

\item{FOR_parameter}{A character string specifying the name of the parameter to set.}

\item{value}{The value to assign to the specified FOR parameter.}
}
\value{
The updated SeaSondeRCS object with the new parameter value.
}
\description{
This function updates a single First Order Region (FOR) parameter in the SeaSondeRCS object.
It creates a single-parameter list and passes it to \code{seasonder_setFOR_parameters()}.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFORParameter(cs_obj, "nsm", 4)
}
