% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getReceiverGain_dB}
\alias{seasonder_getReceiverGain_dB}
\title{Retrieve Receiver Gain in Decibels}
\usage{
seasonder_getReceiverGain_dB(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing header information
about the radar system.}
}
\value{
A numeric value representing the receiver gain in decibels (dB).
}
\description{
This function retrieves the receiver gain value (in decibels) from the header
of a given \code{SeaSondeRCS} object. If the receiver gain field is missing or NULL,
a default value of -34.2 dB is returned.
}
\details{
The function extracts the value of the header field \code{fReferenceGainDB}
using \code{\link{seasonder_getSeaSondeRCS_headerField}}. If the field is not
present or has a NULL value, the function defaults to a receiver gain of -34.2 dB (CODAR, 2016).
}
\references{
Cross Spectra File Format Version 6, CODAR. (2016).
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_headerField}} to retrieve specific fields from
the \code{SeaSondeRCS} header.
}
