% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate-progression-table.R,
%   R/progression-table-DI.R, R/progression-table-RIR.R,
%   R/progression-table-perc-MR.R, R/progression-table-perc-drop.R,
%   R/progression-table-rel-int.R, R/progression-table-variable-DI.R,
%   R/progression-table-variable-RIR.R, R/progression-table.R
\name{generate_progression_table}
\alias{generate_progression_table}
\alias{progression_DI}
\alias{progression_RIR}
\alias{progression_RIR_increment}
\alias{progression_perc_MR}
\alias{progression_perc_MR_variable}
\alias{progression_perc_drop}
\alias{progression_rel_int}
\alias{progression_variable_DI}
\alias{progression_variable_RIR}
\alias{progression_table}
\title{Family of functions to create progression tables}
\usage{
generate_progression_table(
  progression_table,
  type = c("grinding", "ballistic", "conservative"),
  volume = c("intensive", "normal", "extensive"),
  reps = 1:5,
  step = seq(-3, 0, 1),
  ...
)

progression_DI(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  step_increment = -0.025,
  volume_increment = step_increment,
  ...
)

progression_RIR(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  step_increment = 1,
  volume_increment = step_increment,
  ...
)

progression_RIR_increment(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  ...
)

progression_perc_MR(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  step_increment = -0.1,
  volume_increment = -0.2,
  ...
)

progression_perc_MR_variable(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  ...
)

progression_perc_drop(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  ...
)

progression_rel_int(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  step_increment = -0.05,
  volume_increment = -0.075,
  ...
)

progression_variable_DI(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  rep_1_step_increment = -0.02,
  rep_12_step_increment = -0.04,
  rep_1_volume_increment = -0.02,
  rep_12_volume_increment = -0.04,
  ...
)

progression_variable_RIR(
  reps,
  step = 0,
  volume = "normal",
  adjustment = 0,
  type = "grinding",
  mfactor = NULL,
  rep_1_step_increment = 1,
  rep_12_step_increment = 2,
  rep_1_volume_increment = 1,
  rep_12_volume_increment = 2,
  ...
)
}
\arguments{
\item{progression_table}{Progression table function to use}

\item{type}{Character vector. Type of max rep table. Options are grinding (Default), ballistic, and conservative.}

\item{volume}{Character vector: 'intensive', 'normal' (Default), or 'extensive'}

\item{reps}{Numeric vector. Number of repetition to be performed}

\item{step}{Numeric vector. Progression step. Default is 0. Use negative numbers (i.e., -1, -2)}

\item{...}{Extra arguments forwarded to \code{\link{adj_perc_1RM}} family of functions
Use this to supply different parameter value (i.e., \code{k = 0.035}), or model
function (i.e., \code{max_perc_1RM_func = max_perc_1RM_linear)}}

\item{adjustment}{Numeric vector. Additional post adjustment applied to sets. Default is none
(value depends on the method).}

\item{mfactor}{Numeric vector. Factor to adjust max rep table. Used instead of \code{type} parameter,
unless \code{NULL}}

\item{step_increment, volume_increment}{Numeric vector. Used to adjust specific progression methods}

\item{rep_1_step_increment}{Numeric vector. Default 1}

\item{rep_12_step_increment}{Numeric vector. Default 2}

\item{rep_1_volume_increment}{Numeric vector. Default 1}

\item{rep_12_volume_increment}{Numeric vector. Default 2}
}
\value{
List with two elements: \code{adjustment} and \code{perc_1RM}
}
\description{
Family of functions to create progression tables
}
\section{Functions}{
\itemize{
\item \code{generate_progression_table()}: Generates progression tables

\item \code{progression_DI()}: Deducted Intensity progression table. This simplest progression
table simply deducts intensity to progress. Adjust this deducted by using the
\code{deduction} parameter (default is equal to -0.025)

\item \code{progression_RIR()}: Constant RIR Increment progression table. This variant have constant RIR
increment across reps from phases to phases and RIR difference between extensive, normal, and
intensive schemes. Use \code{step_increment} and  \code{volume_increment} parameters to
utilize needed increments

\item \code{progression_RIR_increment()}: RIR Increment progression table (see Strength Training Manual)

\item \code{progression_perc_MR()}: Constant \%MR Step progression table. This variant have constant \%MR
increment across reps from phases to phases and \%MR difference between extensive, normal, and
intensive schemes. Use \code{step_increment} and  \code{volume_increment} parameters to
utilize needed increments

\item \code{progression_perc_MR_variable()}: Variable \%MR Step progression table

\item \code{progression_perc_drop()}: Perc Drop progression table (see Strength Training Manual)

\item \code{progression_rel_int()}: Relative Intensity progression table. Use \code{step_increment}
and  \code{volume_increment} parameters to utilize needed increments

\item \code{progression_variable_DI()}: Variable Deducted Intensity progression table. This function
allows you to generate variable Deducted Intensity table, with adjustments linearly
increasing for both step progressions as well volume increment based on the reps done.

\item \code{progression_variable_RIR()}: Variable RIR progression table. This function
allows you to generate variable RIR progression table, with adjustments linearly
increasing for both step progressions as well volume increment based on the reps done.

}}
\examples{
generate_progression_table(progression_RIR)

generate_progression_table(
  progression_RIR,
  type = "grinding",
  volume = "normal",
  step_increment = 2
)

# Create progression table using specific reps-max table and k value
generate_progression_table(
  progression_RIR,
  max_perc_1RM_func = max_perc_1RM_modified_epley,
  kmod = 0.0388
)
# ------------------------------------------
# Progression Deducted Intensity
progression_DI(10, step = seq(-3, 0, 1))
progression_DI(10, step = seq(-3, 0, 1), volume = "extensive")
progression_DI(5, step = seq(-3, 0, 1), type = "ballistic", step_increment = -0.05)
progression_DI(
  5,
  step = seq(-3, 0, 1),
  type = "ballistic",
  step_increment = -0.05,
  volume_increment = -0.1
)

# Generate progression table
generate_progression_table(progression_DI, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_DI,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)

# ------------------------------------------
# Progression RIR Constant
progression_RIR(10, step = seq(-3, 0, 1))
progression_RIR(10, step = seq(-3, 0, 1), volume = "extensive")
progression_RIR(5, step = seq(-3, 0, 1), type = "ballistic", step_increment = 2)
progression_RIR(
  5,
  step = seq(-3, 0, 1),
  type = "ballistic",
  step_increment = 3
)

# Generate progression table
generate_progression_table(progression_RIR, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_RIR,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)

# Plot progression table
plot_progression_table(progression_RIR)
plot_progression_table(progression_RIR, "adjustment")
# ------------------------------------------
# Progression RIR Increment
progression_RIR_increment(10, step = seq(-3, 0, 1))
progression_RIR_increment(10, step = seq(-3, 0, 1), volume = "extensive")
progression_RIR_increment(5, step = seq(-3, 0, 1), type = "ballistic")

# Generate progression table
generate_progression_table(progression_RIR_increment, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_RIR_increment,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)
# ------------------------------------------
# Progression \%MR Step Const
progression_perc_MR(10, step = seq(-3, 0, 1))
progression_perc_MR(10, step = seq(-3, 0, 1), volume = "extensive")
progression_perc_MR(5, step = seq(-3, 0, 1), type = "ballistic", step_increment = -0.2)
progression_perc_MR(
  5,
  step = seq(-3, 0, 1),
  type = "ballistic",
  step_increment = -0.15,
  volume_increment = -0.25
)

# Generate progression table
generate_progression_table(progression_perc_MR, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_perc_MR,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)

# ------------------------------------------
# Progression \%MR Step Variable
progression_perc_MR_variable(10, step = seq(-3, 0, 1))
progression_perc_MR_variable(10, step = seq(-3, 0, 1), volume = "extensive")
progression_perc_MR_variable(5, step = seq(-3, 0, 1), type = "ballistic")
# Generate progression table
generate_progression_table(progression_perc_MR_variable, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_perc_MR_variable,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)
# ------------------------------------------
# Progression Perc Drop
progression_perc_drop(10, step = seq(-3, 0, 1))
progression_perc_drop(10, step = seq(-3, 0, 1), volume = "extensive")
progression_perc_drop(5, step = seq(-3, 0, 1), type = "ballistic")

# Generate progression table
generate_progression_table(progression_perc_drop, type = "grinding", volume = "normal")

# Use different reps-max model
generate_progression_table(
  progression_perc_drop,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)
# ------------------------------------------
# Progression Relative Intensity
progression_rel_int(10, step = seq(-3, 0, 1))
progression_rel_int(10, step = seq(-3, 0, 1), volume = "extensive")
progression_rel_int(5, step = seq(-3, 0, 1), type = "ballistic")

# Generate progression table
generate_progression_table(progression_rel_int, type = "grinding", volume = "normal")
generate_progression_table(progression_rel_int, step_increment = -0.1, volume_increment = 0.15)

# Use different reps-max model
generate_progression_table(
  progression_rel_int,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)
# ------------------------------------------
# Progression Variable Deducted Intensity
progression_variable_DI(10, step = seq(-3, 0, 1))
progression_variable_DI(10, step = seq(-3, 0, 1), volume = "extensive")
progression_variable_DI(5, step = seq(-3, 0, 1), type = "ballistic")
progression_variable_DI(
  5,
  step = seq(-3, 0, 1),
  type = "grinding",
  rep_1_step_increment = -0.02,
  rep_12_step_increment = -0.04,
  rep_1_volume_increment = -0.02,
  rep_12_volume_increment = -0.04
)


# Generate progression table
generate_progression_table(
  progression_variable_DI,
  type = "grinding",
  volume = "normal"
)

# Use different reps-max model
generate_progression_table(
  progression_variable_DI,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)

# Recreate "progression_perc_drop()" for grinding
setequal(
  generate_progression_table(
    progression_variable_DI,
    type = "grinding",
    rep_1_step_increment = -0.025,
    rep_12_step_increment = -0.05,
    rep_1_volume_increment = -0.025,
    rep_12_volume_increment = -0.05
  ),
  generate_progression_table(
    progression_perc_drop,
    type = "grinding"
  )
)

# ------------------------------------------
# Progression Variable RIR
progression_variable_RIR(10, step = seq(-3, 0, 1))
progression_variable_RIR(10, step = seq(-3, 0, 1), volume = "extensive")
progression_variable_RIR(5, step = seq(-3, 0, 1), type = "ballistic")
progression_variable_RIR(
  5,
  step = seq(-3, 0, 1),
  type = "grinding",
  rep_1_step_increment = 1,
  rep_12_step_increment = 2,
  rep_1_volume_increment = 2,
  rep_12_volume_increment = 4
)


# Generate progression table
generate_progression_table(
  progression_variable_DI,
  type = "grinding",
  volume = "normal"
)

# Use different reps-max model
generate_progression_table(
  progression_variable_RIR,
  type = "grinding",
  volume = "normal",
  max_perc_1RM_func = max_perc_1RM_linear,
  klin = 36
)

# Recreate "progression_RIR_increment()" for grinding
setequal(
  generate_progression_table(
    progression_variable_RIR,
    type = "grinding",
    rep_1_step_increment = 1,
    rep_12_step_increment = 2,
    rep_1_volume_increment = 1,
    rep_12_volume_increment = 3
  ),
  generate_progression_table(
    progression_RIR_increment,
    type = "grinding"
  )
)

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Jovanović M. 2020. Strength Training Manual: The Agile Periodization Approach.
Independently published.
}\if{html}{\out{</div>}}
}
