% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/furt.R
\name{furt}
\alias{furt}
\title{Functional Unit Root Test}
\usage{
furt(
  X,
  ALPHA = 0.05,
  TYPE = "R",
  METHOD = "MC",
  K = default_kernel,
  h_power = 2/5,
  est_ev = nrow(X) - 1,
  MCNsim = 10000,
  bm_set = NULL,
  M = 1000,
  b = ceiling((2 * (nrow(X) - 1))^(1/3))
)
}
\arguments{
\item{X}{The functional time series being tested, inputted in a matrix form with each row representing each observation of the functional data values on equidistant points of any prespecified interval.}

\item{ALPHA}{Significance level of the test. The default value is 5\%.}

\item{TYPE}{Type of hypothesis test. The default value 'TYPE="R"' represents the right-tailed test, which is used when the alternative hypothesis is trend stationarity model. 'TYPE="L"' represents the left-tailed test, which is used when the alternative hypothesis is simple stationarity model or AR(1) model.}

\item{METHOD}{Method to determine the critical value of the test statistic. The default value 'METHOD="MC"' represents the Monte Carlo method. 'METHOD="SB"' represents the simple bootstrap method and 'METHOD="MBB"' represents the moving block bootstrap method.}

\item{K}{Kernel function in the estimation of the long-run covariance function, which is only effective in the Monte Carlo method. The default function is 'default_kernel' function in this package.}

\item{h_power}{Power of sample size 'N' (valued in (0,1)) for the smoothing bandwidth, which is only effective in the Monte Carlo method. The default value is 2/5.}

\item{est_ev}{Number of the largest eigenvalues chosen to estimate the limiting distribution, which is only effective in the Monte Carlo method. The default value is the sample size 'N'.}

\item{MCNsim}{Number of Monte Carlo datasets generated in the Monte Carlo method, which is only effective in Monte Carlo method. The default value is 10000.}

\item{bm_set}{A vector of independent simulated data generated from the function 'dataset_bm', which is only effective and essential in Monte Carlo method.}

\item{M}{Number of bootstrap datasets generated in the bootstrap method, which is only effective in bootstrap methods. The default value is 1000.}

\item{b}{Block length used in the moving block bootstrap method, which is only effective in the moving block bootstrap method. The default value is ceiling((2N)^(1/3)), where 'N' is the sample size.}
}
\value{
The result of the test is presented with the value of test statistic and its p-value under the null hypothesis of functional random walk.
}
\description{
Unit root test for functional time series with different methods on determining the critical values of the test statistic. The Monte Carlo method was constructed in Chen and Pun (2021), while the bootstrap-based methods have not been validated in the literature (although such an option is provided, please use them at your own risk).
}
\examples{
N<-100
EE<-matrix(rep(0,N*100),ncol=100)
EX<-matrix(rep(0,N*100),ncol=100)
set.seed(1)
for (i in 1:N) {
temp<-rnorm(100,0,1)
EE[i,1]<-temp[1]
for (j in 2:100) {
EE[i,j]<-EE[i,j-1]+temp[j]
}
}
EX[1,]<-EE[1,]
for (i in 2:N) {EX[i,]<-EX[i-1]+EE[i,]}
furt(X=EX,METHOD="SB")
}
\references{
Chen, Y., & Pun, C. S. (2021). Functional Unit Root Test. Available at SSRN.
}
