% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FST_teststat_TN.R
\name{FST_teststat_TN}
\alias{FST_teststat_TN}
\title{Test Statistic T_N in Functional Stationarity Test}
\usage{
FST_teststat_TN(X)
}
\arguments{
\item{X}{The functional time series being tested, inputted in a matrix form with each row representing each observation of the functional data values on equidistant points of any prespecified interval.}
}
\value{
The value of test statistic T_N calculated for functional stationarity test.
}
\description{
Calculate test statistic T_N for functional stationarity test, which was constructed in Horvath et al. (2014).
}
\examples{
N<-100
EX<-matrix(rep(0,N*100),ncol=100)
set.seed(1)
for (i in 1:N) {
temp<-rnorm(100,0,1)
EX[i,1]<-temp[1]
for (j in 2:100) {
EX[i,j]<-EX[i,j-1]+temp[j]
}
}
FST_teststat_TN(EX)
}
\references{
Horvath, L., Kokoszka, P., & Rice, G. (2014). Testing stationarity of functional time series. Journal of Econometrics, 179(1), 66-82.
}
