% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_generalized.R
\name{simulation_generalized}
\alias{simulation_generalized}
\title{Simulate Multivariate Crop Yield Data Using a Generalized Copula-GEV-BSTS Model}
\usage{
simulation_generalized(
  nsim = 100,
  n_train,
  n_test,
  copula,
  init_params,
  fn,
  U_train,
  Z_train,
  X,
  Y_test,
  BSTS_list
)
}
\arguments{
\item{nsim}{Integer, number of simulation replications.}

\item{n_train}{Integer, number of training observations.}

\item{n_test}{Integer, number of test observations.}

\item{copula}{Character, specifying the copula type: "Clayton", "Frank",
"Gumbel", "Joe", or "Gaussian".}

\item{init_params}{Numeric vector, initial parameter values for optimization.}

\item{fn}{Function, log-likelihood function for parameter estimation.}

\item{U_train}{Numeric matrix (n_train x D), pseudo-observations for the copula.}

\item{Z_train}{Numeric array (n_train x D x M), observed data for each margin and sub-feature.}

\item{X}{Numeric matrix (n_train x M), risk factors for the dynamic copula parameter.}

\item{Y_test}{Numeric matrix (n_test x D), true future values for MSE calculation.}

\item{BSTS_list}{List of length D, each element is a BSTS model for a different margin.}
}
\value{
A list containing:
\item{optim_results}{Results from the optimization process.}
\item{theta_sim}{Simulated copula parameters across replications.}
\item{Y_sim}{Simulated final BSTS-based forecasts.}
\item{MSE}{Mean squared error for each simulation run.}
}
\description{
This function simulates multivariate crop yield data using a time-varying copula
combined with Generalized Extreme Value (GEV) margins and Bayesian Structural Time Series (BSTS) models.
}
