% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od_table.R
\name{od_table}
\alias{od_table}
\title{Create a table-instance from an open-data dataset}
\usage{
od_table(id, language = NULL, server = "ext")
}
\arguments{
\item{id}{the id of the dataset that should be accessed}

\item{language}{language to be used for labeling. \code{"en"} or \code{"de"}}

\item{server}{the OGD-server to be used. \code{"ext"} (the default) for the
external server or \code{prod} for the production server}
}
\value{
The returned objects is of class \code{sc_table} and inherits several parsing
methods from \link{sc_data}. See \link{od_table_class} for the full class
documentation.
}
\description{
\code{od_table(id)} returns an \code{R6}-class object containing all relevant data
and metadata from https://data.statistik.gv.at/data/
}
\section{Components}{
\tabular{ll}{
   \strong{Component} \tab \strong{Corresponding File on Server} \cr
   \verb{$data         } \tab \verb{https://data.statistik.gv.at/data/$\{id\}.csv} \cr
   \verb{$header       } \tab \verb{https://data.statistik.gv.at/data/$\{id\}_HEADER.csv} \cr
   \verb{$field(code)  } \tab \verb{https://data.statistik.gv.at/data/$\{id\}_$\{code\}.csv} \cr
   \verb{$json         } \tab \verb{https://data.statistik.gv.at/ogd/json?dataset=$\{id\}} \cr
}
}

\examples{
x <- od_table("OGD_krebs_ext_KREBS_1")

## metadata
x
x$meta
x$field("Sex")
x$field(3)

## data
x$data
x$tabulate()

## tabulation: see `?sc_tabulate` for more examples
x$tabulate("Reporting year", "Sex")

## switch language
x$language <- "de"
x
x$tabulate()

## other interesting tables
od_table("OGD_veste309_Veste309_1")
od_table("OGD_konjunkturmonitor_KonMon_1")
od_table("OGD_krankenbewegungen_ex_LEISTUNGEN_1")
od_table("OGD_veste303_Veste203_1")
}
