% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_FMM_SemiSupervised_Initial.R
\name{EM_FMM_SemiSupervised_Initial}
\alias{EM_FMM_SemiSupervised_Initial}
\title{Quick Initializer for alpha, xi, and Mixture Parameters}
\usage{
EM_FMM_SemiSupervised_Initial(
  Y_labelled,
  Z_labelled,
  Y_unlabelled,
  g = 2,
  pi_init = NULL,
  mu_init = NULL,
  Sigma_init = NULL,
  alpha_init = 0.01,
  warm_up_iter = 50,
  tol = 1e-06
)
}
\arguments{
\item{Y_labelled}{Numeric matrix of labeled observations (\eqn{n_L \times p}).}

\item{Z_labelled}{Integer vector of class labels in \code{1:g} for
\code{Y_labelled}.}

\item{Y_unlabelled}{Numeric matrix of unlabeled observations
(\eqn{n_U \times p}).}

\item{g}{Integer, number of mixture components (default \code{2}).}

\item{pi_init}{Optional numeric length-\code{g} vector of initial mixing
proportions.}

\item{mu_init}{Optional list of length \code{g} of initial mean vectors
(each of length \code{p}).}

\item{Sigma_init}{Optional initial covariance:
a \eqn{p \times p} matrix (shared), or a list of \code{g}
\eqn{p \times p} matrices, or a \eqn{p \times p \times g} array
(class-specific).}

\item{alpha_init}{Numeric in \eqn{(0,1)}, initial MCAR proportion
(default \code{0.01}).}

\item{warm_up_iter}{Integer, number of warm-up EM iterations used to
refine the quick initial estimates (default \code{50}).}

\item{tol}{Convergence tolerance on \code{alpha} (default \code{1e-6}).}
}
\value{
A list with elements:
\itemize{
\item \code{pi} - length-\code{g} vector of mixing proportions.
\item \code{mu} - list of \code{g} mean vectors.
\item \code{Sigma} - shared \eqn{p \times p} matrix (equal-Sigma) or list
of \code{g} matrices (unequal-Sigma).
\item \code{xi} - length-2 numeric vector \code{c(xi0, xi1)} from the
logistic MAR model.
\item \code{alpha} - estimated MCAR proportion.
\item \code{gamma} - \eqn{n \times g} responsibility matrix.
\item \code{d2_yj} - numeric vector of entropy-based scores used in the
missingness model.
}
}
\description{
Provides rough initial estimates of the missingness parameters \code{alpha}
and \code{xi}, together with mixture parameters \code{pi}, \code{mu}, and
covariance matrices, using a lightweight EM-style routine. The covariance
structure is chosen automatically based on \code{Sigma_init}:

\itemize{
\item If \code{Sigma_init} is a \eqn{p \times p} matrix, a
\strong{shared (equal)} covariance is used.
\item If \code{Sigma_init} is a list of length \code{g} of
\eqn{p \times p} matrices or a \eqn{p \times p \times g} array,
\strong{class-specific (unequal)} covariances are used.
\item If \code{Sigma_init} is \code{NULL}, a shared covariance is
estimated from the labeled data.
}

This function is intended as a fast, heuristic initializer rather than a
final estimator for the mixed missingness model.
}
\note{
This is a heuristic warm-up routine. It requires helper functions
\code{normalise_logprob()} and \code{get_entropy()} to be available in the
package namespace.
}
