#' Windmill and current
#'
#' The amount of direct current (DC) output from windmills for 
#' varying wind velocities.
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @format A data frame with 25 rows (each windmill) and 2 columns:
#' \describe{
#'   \item{Wind}{The wind velocity, in miles per hour}
#'   \item{DC}{The DC output}
#' }
#' 
#' @source G. Joglekar, J. H. Schuenemeyer and V. LaRicca (1989) 
#' Lack-of-fit testing when replicates are not available. 
#' \emph{American Statistician}, \bold{43}, 135--143.
#' 
#' @references 
#' D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway, and E. Ostrowski (1994). 
#' \emph{A Handbook of Small Data Sets}, London: Chapman and Hall. Dataset 271.
#' 
#' D. C. Montgomery and E. A. Peck (1982).
#' \emph{Introduction to Linear Regression Analysis}. New York: John Wiley.
#'  
#' @usage 
#' data(Windmill)
#' 
#' @examples
#' plot(DC ~ Wind, data = Windmill, xlab = "Wind speed (miles/h)", ylab = "DC output")
#' 

"Windmill"
