% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_depth.R
\name{max_depth}
\alias{max_depth}
\title{Vizualise and filter based on mean depth across all called SNPs}
\usage{
max_depth(vcfR, maxdepth = NULL)
}
\arguments{
\item{vcfR}{a vcfR object}

\item{maxdepth}{an integer specifying the maximum mean depth for a SNP to be retained}
}
\value{
The vcfR object input, with SNPs above the 'maxdepth' cutoff removed
}
\description{
This function can be run in two ways: 1) specify vcfR object only. This will
visualize the distribution of mean depth per sample across all SNPs in your vcf file,
and will not alter your vcf file. 2) specify vcfR object, and set 'maxdepth' = 'integer value'.
This option will show you where your specified cutoff falls in the distribution of SNP depth,
and remove all SNPs with a mean depth above the specified threshold from the vcf.
Super high depth loci are likely multiple loci stuck together into a single paralogous locus.
Note: This function filters on a 'per SNP' basis rather than a 'per genotype' basis,
otherwise it would disproportionately remove genotypes from our deepest sequenced samples
(because sequencing depth is so variable between samples).
}
\examples{
max_depth(vcfR = SNPfiltR::vcfR.example)
max_depth(vcfR = SNPfiltR::vcfR.example, maxdepth = 100)
}
