% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepOne.R
\name{StepOne}
\alias{StepOne}
\title{Penalized mediation and outcome models}
\usage{
StepOne(X, M, time, status, model_option = "MCP")
}
\arguments{
\item{X}{An n by p matrix of exposures.}

\item{M}{An n by p matrix of mediators.}

\item{time}{A vector of survival time of samples.}

\item{status}{A vector of status indicator: 0=alive, 1=dead.}

\item{model_option}{The penalization method used when selecting X for M. The options include MCP, elastic net and lasso. Default is MCP.}
}
\value{
A list with the following components:
\item{X_sel_Y_s1}{X selected for Y using penAFT}
\item{M_X_s1}{X selected for M using the selected penalized model}
\item{M_sel_Y_s1}{M selected for Y using penAFT}
}
\description{
An auxiliary function which conducts variable selection of X for Y using penAFT, X for M using the selected penalized model and M for Y using penAFT.
}
\examples{
\donttest{
data(example_dat)
surv_dat <- example_dat$surv_dat
res_step1 <- StepOne(X = example_dat$X, M = example_dat$M, time = surv_dat$time,
status = surv_dat$status, model_option = "MCP")
}

}
