% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sep.test.R
\name{sep.test}
\alias{sep.test}
\title{User-specified separability test}
\usage{
sep.test(
  ts,
  c,
  d,
  m = "MV",
  b_time,
  b_timese,
  mp_type,
  type,
  fix_num = 0,
  r = 1,
  s = 1,
  n_point = 2000,
  upper = 10
)
}
\arguments{
\item{ts}{ts is the data set which is a time series data typically}

\item{c}{the maximum value of number of basis for time input}

\item{d}{the maximum value of number of basis for variate input}

\item{m}{the window size for the simultaneous confidence region procedure, with the default being 'MV,' which stands for the Minimum Volatility method}

\item{b_time}{type of basis for time input}

\item{b_timese}{type of basis for variate input}

\item{mp_type}{select type of mapping function, "algeb" indicates algebraic mapping on the real line. "logari" represents logarithmic mapping on the real line}

\item{type}{select type of estimation."fixt" indicates fix time t estimation. "fixx" represents fix variate estimation}

\item{fix_num}{fix_num indicates the use of fixed-value nonlinear time series regression. If "fixt" is chosen, it represents a fixed time value. Otherwise,
if not selected, it pertains to a fixed variate value}

\item{r}{indicates number of variate}

\item{s}{s is a positive scaling factor, the default is 1}

\item{n_point}{number of points for SCR, the default is 2000}

\item{upper}{upper The upper bound for the variate basis domain. The default value is 10. When "algeb" or "logari" is chosen, the domain is automatically set from -upper to upper}
}
\value{
A list containing dataframes with three columns each. The first column represents input values. The second column contains values of the estimated function,
along with their upper and lower bounds, which are used for separability testing. The third column is a factor indicating the types corresponding to the values
in the second column.
}
\description{
This function utilizes Simultaneous Confidence Regions (SCR) for the automated execution of separability tests
}
