% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMhelp.R
\name{nplot}
\alias{nplot}
\title{Create a plot for a neural network model}
\usage{
nplot(object, hidden, bias = TRUE, sleep = 2, ...)
}
\arguments{
\item{object}{A neural network model object}

\item{hidden}{The hidden structure of the object}

\item{bias}{A logical value, indicating whether to draw biases in 
the layers (default = FALSE).}

\item{sleep}{Suspend plot display for a specified time (in secs, default = 2).}

\item{...}{Currently ignored.}
}
\value{
The function invisibly returns the graphical objects representing
the neural network architecture designed by NeuralNetTools.
}
\description{
The function uses the \code{\link[NeuralNetTools]{plotnet}}
function of the \pkg{NeuralNetTools} R package to draw a neural network
plot and visualize the hidden layer structure.
}
\details{
The induced subgraph of the input graph mapped on data 
variables. Based on the estimated connection weights, if the connection
weight W > 0, the connection is activated and it is highlighted in red;  
if W < 0, the connection is inhibited and it is highlighted in blue.
}
\examples{

\donttest{
if (torch::torch_is_installed()){

# load ALS data
ig<- alsData$graph
data<- alsData$exprs
data<- transformData(data)$data

#ncores<- parallel::detectCores(logical = FALSE)
dnn0 <- SEMdnn(ig, data, train=1:nrow(data), algo = "layerwise",
			hidden = c(10, 10, 10), link = "selu", bias =TRUE,
			epochs = 32, patience = 10, verbose = TRUE)

 #Visualize the neural networks per each layer of dnn0
 nplot(dnn0, hidden = c(10, 10, 10), bias = FALSE)
}
}

}
\references{
Beck, M.W. 2018. NeuralNetTools: Visualization and Analysis Tools for Neural 
Networks. Journal of Statistical Software. 85(11):1-20.
}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
