% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cma.R
\name{mean_response_predict}
\alias{mean_response_predict}
\title{Functional Outcome Regression Prediction with Group-Specific Inference}
\usage{
mean_response_predict(
  data_df,
  object,
  fitted = TRUE,
  outcome,
  domain,
  subset = NULL,
  id
)
}
\arguments{
\item{data_df}{A functional data frame that contains both name and values for
variables including functional outcome, domain (e.g. time) and ID (e.g. subject names)
used to fit the model \code{object}.}

\item{object}{A fitted Function-on-Scalar Regression (FoSR) model object
(e.g., from mgcv::gam()/mgcv::bam()).}

\item{fitted}{Logical. Whether to estimate the simultaneous confidence bands
for the fitted mean function or the fitted parameter function
\itemize{
\item \code{TRUE} - Estimate the simultaneous confidence bands
for the fitted mean outcome function.
\item \code{FALSE} - estimate the simultaneous confidence bands
for the fitted parameter function.
}
Default is \code{TRUE}.}

\item{outcome}{A character string specifying the name of the outcome variable
used in the model.}

\item{domain}{A character string specifying the name of the domain variable
(e.g. time) used in the model.}

\item{subset}{An atomic character vector (e.g., c("user = 1", "age = 30"))
specifying the target function for constructing the SCB.
Each element must be of the form \verb{<name> = <value>}, where \verb{<name>} is
the name of a scalar grouping variable and \verb{<value>} is the desired value.
Whitespace is ignored. Binary or categorical character variables should be
transformed into numeric. Factors are not allowed here because if the input
data contains factor variables, they will be automatically expanded into
dummy (indicator) variables when constructing the design matrix, and
the resulting variable names may differ from the original factor names.
Default is \code{NULL}, which represents the reference group.}

\item{id}{A character string specifying the name of the ID variable.}
}
\value{
A list containing the following elements:
\describe{
\item{s_pred}{Numeric vector of sorted unique domain used for prediction}
\item{pred_df}{Data frame with prediction results, containing:
\itemize{
\item \code{mean}: Predicted mean values
\item \code{se}: Standard errors
}
}
\item{lpmat}{Linear predictor matrix (design matrix)
used for confidence interval calculations}
\item{mod_coef}{Vector of model coefficients for selected group}
\item{mod_cov}{Variance-covariance matrix corresponding to
the selected group coefficients}
}
}
\description{
This function is an internal function for constructing SCBs for functional data.
}
\examples{
if (requireNamespace("mgcv", quietly = TRUE)) {
data(pupil)

\donttest{
pupil_fpca <- prepare_pupil_fpca(pupil)

fosr_mod <- mgcv::bam(percent_change ~ s(seconds, k=30, bs="cr") +
  s(seconds, by = use, k=30, bs = "cr") +
  s(id, by = Phi1, bs="re") +
  s(id, by = Phi2, bs="re") +
  s(id, by = Phi3, bs="re") +
  s(id, by = Phi4, bs="re"),
  method = "fREML", data = pupil_fpca, discrete = TRUE)

results <- mean_response_predict(pupil_fpca, fosr_mod, fitted = TRUE,
outcome = "percent_change", domain = "seconds", subset = c("use = 1"), id = "id")}

mean_mod <- mgcv::gam(percent_change ~ s(seconds, k = 5, bs = "cr") +
s(seconds, by = use, k = 5, bs = "cr"),
data = pupil, method = "REML")

results <- mean_response_predict(pupil, mean_mod, fitted = TRUE,
outcome = "percent_change", domain = "seconds", subset = c("use = 1"), id = "id")
}

}
\references{
Crainiceanu, C. M., Goldsmith, J., Leroux, A., & Cui, E. (2024).
\emph{Functional Data Analysis with R}.
Chapman and Hall/CRC.
}
