% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scout.R
\name{scout}
\alias{scout}
\title{scout}
\usage{
scout(
  X,
  pcaref,
  T2.y = NA,
  SPE.y = NA,
  nsteps = 1,
  nsteps.spe = 1,
  nsteps.t2 = 1,
  gspe = 1,
  gt2 = 1,
  mode = "simple"
)
}
\arguments{
\item{X}{Matrix with observations that will be shifted as rows.}

\item{pcaref}{List with the elements of a PCA model:
\itemize{
\item \code{m}: mean.
\item \code{s}: standard deviation.
\item \code{prepro}: preprocessing: \code{"none"}, \code{"cent"} or \code{"autosc"}.
\item \code{P}: loading matrix.
\item \code{lambda}: vector with variances of each PC.
}}

\item{T2.y}{A number indicating the target value for the Hotelling's T^2_A after the shift.
Set to \code{NA} by default.}

\item{SPE.y}{A number indicating the target value for the Squared Prediction Error after the
shift. Set to \code{NA} by default.}

\item{nsteps}{A number indicating the number of steps between the reference and target
values of the SPE and the T^2. Set to \code{1} by default.}

\item{nsteps.spe}{An integer indicating the number of steps in which the shift from
the reference to the target value of the SPE will be performed. Set to \code{1} by default.}

\item{nsteps.t2}{An integer indicating the number of steps in which the shift from the
reference to the target value of the T^2_A will be performed. Set to \code{1} by default.}

\item{gspe}{A number indicating the term that will tune the spacing between steps for the SPE.
Set to \code{1} by default (linear spacing).}

\item{gt2}{A number indicating the term that will tune the spacing between steps for the SPE.
Set to \code{1} by default (linear spacing).}

\item{mode}{A character indicating the type of shift that will be performed: \code{"simple"},
\code{"steps"} or \code{"grid"}.}
}
\value{
list with elements:
\itemize{
\item \code{X}: matrix with the new and shifted data.
\item \code{SPE}: SPE of each one of the generated outliers in the list element \code{X}.
\item \code{T2}: T^2 of each one of the generated outliers in the list element \code{X}.
\item \code{step.spe}: step of each observation according to the shift of the SPE.
\item \code{step.t2}: step of each observation according to the shift of the T^2.
\item \code{tag}: is a vector of ones as long as the number of generated observations.
}
}
\description{
Shift of an observation following a selected pattern.
}
\examples{
X <- as.matrix(X)
pcamodel.ref <- pcamb_classic(X, 3, 0.1, "autosc") # PCA-MB with all observations
# Shift the first observation:
outscout <- scout(X[1,], pcamodel.ref, T2.y = 40, SPE.y = 50, nsteps.spe = 3, nsteps.t2 = 2, 
gspe = 3, gt2 = 0.5, mode = "grid")

# Shift a set of observations increasing only the T^2 in one step:
outscout <- scout(X, pcamodel.ref, T2.y = matrix(40, nrow(X), 1), mode = "simple")
}
