% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensions.R
\name{get_last_played}
\alias{get_last_played}
\title{Last Played Match}
\usage{
get_last_played(region_id, realm_id, profile_id, host_region = "us")
}
\arguments{
\item{region_id}{A numeric argument indicating the region of the profile.
    \itemize{
        \item 1 = US Region
        \item 2 = EU Region
        \item 3 = KR/TW Region
        \item 5 = CN Region
}}

\item{realm_id}{A numeric argument indicating the realm of the profile. A realm is a subset
of the region.
 \itemize{
     \item{US Region}
         \itemize{
             \item{1 = US}
             \item{2 = LatAm}
         }
     \item{EU Region}
         \itemize{
             \item{1 = Europe}
             \item{2 = Russia}
     }
     \item{KR/TW Region}
         \itemize{
             \item{1 = Korea}
             \item{2 = Taiwan}
     }
 }}

\item{profile_id}{A unique, numeric identifier for an individual's profile.}

\item{host_region}{The host region that the API call will be sent to. For most API calls, the same data will be
returned regardless of which region the request is sent to. Must be one of "us", "eu", "kr", "tw", "cn". For more
information on regionality, refer to
\href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}.}
}
\description{
Get the time of the last played match in a player's match history.
}
\note{
Data is only available for season 28 and higher.
}
\examples{
\donttest{
# Get last played match for a particular profile
try(get_last_played(1, 4716773, host_region = "us"))
}
}
\references{
\itemize{
   \item \href{https://develop.battle.net/documentation/starcraft-2/community-apis}{Blizzard Community API Documentation}
   \item \href{https://develop.battle.net/documentation/guides/regionality-and-apis}{Regionality and APIs}
   }
}
